/*
 * $Id: fusenshiwnd.h,v 1.2 2004/04/01 11:55:30 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.2 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#ifndef ___FUSENSHIWND_H
#define ___FUSENSHIWND_H

#include "../include/fusenshidata.h"

#include "gtkmm.h"

class FusenshiWnd : public Gtk::Window
{
public:
    /**
     * 󥹥ȥ饯
     */
    FusenshiWnd(FusenshiData *pData, guint nFileID);

    /**
     * ǥȥ饯
     */
    ~FusenshiWnd();

public:
    /**
     * 䵻楦ɥɸॿפꤷޤ
     * 
     * @param pWndProp 䵻楦ɥɸॿ
     */
    static void setDefaultWindowType(WND_TYPE nWndType);

protected:
    /**
     * ɥκ׵ޤ
     */
    virtual bool on_delete_event(GdkEventAny* pEvent);
    
    /**
     * ɽ줿Ȥν
     */
    virtual void on_show();
    
    /**
     * ɥΰ֡ѹα
     */
    virtual bool on_configure_event(GdkEventConfigure* pEvent);
    
    /**
     * ɥξѹα
     */
    virtual bool on_window_state_event(GdkEventWindowState* pEvent);
    
    /**
     * ƥȥӥ塼Υݥåץåץ˥塼򥫥ޥ
     */
    virtual void on_populate_popup(Gtk::Menu* pMenu);
    
    /**
     * GtkDrawingArea
     */
    virtual bool on_expose_event(GdkEventExpose* pEvent);
    
    /**
     * ΰΥޥܥβ˱
     */
    virtual bool on_tag_press_event(GdkEventButton* pEvent);
    
    /**
     * ե졼ΰΥޥܥβ˱
     */
    virtual bool on_frame_press_event(GdkEventButton* pEvent);
    
    /**
     * Խ׵
     */
    virtual void on_edit();

    /**
     * 粽
     */
    virtual void on_maximize();

    /**
     * Ǿ
     */
    virtual void on_minimize();

    /**
     * ׵
     */
    virtual void on_send();

    /**
     * ׵
     */
    virtual void on_print();

    /**
     * ׵
     */
    virtual void on_delete();
    
    /**
     * ɥ褹
     */
    virtual void drawWindowShape();

private:
    /**
     * 䵻ꤷޤ
     */
    void refresh();
    
    /**
     * XWindowSystemľܥɥ֤ޤ
     */
    int getXLibWindowStyle();
    
private:
    /**
     * 䵻
     */
    FusenshiData* m_pData;
    
    /**
     * ե륤ǥå
     */
    guint m_nFileID;
    
    /**
     * ƥȥӥ塼
     */
    Gtk::TextView m_cTextView;
    
    /**
     * 륦ɥ
     */
    Gtk::ScrolledWindow m_cScrolledWnd;
    
    /**
     * 
     */
    Gtk::DrawingArea m_cDrawingArea;
    
    /**
     * XWindowåѥ٥ȥܥå
     */
    Gtk::EventBox m_cEventBox;

    /**
     * ɥ
     */
    WND_TYPE m_nWndType;
    
private:
    /**
     * 䵻楦ɥɸॿ
     */
    static WND_TYPE m_nDefaultWndType;
};

#endif
