/*
 * $Id: propertydialog.cpp,v 1.1 2004/04/01 08:53:26 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "propertydialog.h"

#include <netinet/in.h>
#include <arpa/inet.h>

/**
 * 󥹥ȥ饯
 */
PropertyDialog::PropertyDialog(const PropertyData& property)
{
    m_cOriginalData = property;
    m_cData = property;
    
    set_wmclass(APP_NAME, "PropertyDialog");
    set_title(_("Fusenshi - Property"));
    set_modal(true);
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(400, 370);
    property_destroy_with_parent() = true;

    Gtk::Notebook* pNotebook = manage(new Gtk::Notebook());
    get_vbox()->pack_start(*pNotebook, true, true, 0);

    createBasePage(*pNotebook);
    createNetworkPage(*pNotebook);

    get_action_area()->set_layout(Gtk::BUTTONBOX_END);

    Gtk::Button* pButton = manage(new Gtk::Button(Gtk::StockID("gtk-cancel")));
    add_action_widget(*pButton, Gtk::RESPONSE_CANCEL);
    //pButton->set_flags(Gtk::CAN_DEFAULT);

    pButton = manage(new Gtk::Button(Gtk::StockID("gtk-ok")));
    add_action_widget(*pButton, Gtk::RESPONSE_OK);
    pButton->set_flags(Gtk::CAN_DEFAULT);

    set_default_response(Gtk::RESPONSE_OK);

    // ¸Υǡ
    gchar buf[1024] = {0};
    const guint bufsize = sizeof(buf) -1;

    memset(buf, '\0', sizeof(buf));
    
    // ץѥƥ
    m_cNickName.set_text(m_cData.getNickName());
    
    Gdk::Color bgColor((GdkColor*)m_cData.getBackground());
    snprintf(buf, bufsize, "#%02X%02X%02X", 
             (int)rint(bgColor.get_red_p() * 0xff),
             (int)rint(bgColor.get_green_p() * 0xff),
             (int)rint(bgColor.get_blue_p() * 0xff));
    m_cBackground.set_text(buf);

    Gdk::Color fgColor((GdkColor*)m_cData.getForeground());
    snprintf(buf, bufsize, "#%02X%02X%02X", 
             (int)rint(fgColor.get_red_p() * 0xff),
             (int)rint(fgColor.get_green_p() * 0xff),
             (int)rint(fgColor.get_blue_p() * 0xff));
    m_cForeground.set_text(buf);
    
    m_cFontName.set_text(m_cData.getFontName());
    
    m_cPrintCommand.set_text(m_cData.getPrintCommand());
    
    m_cNetButton.set_active(m_cData.isEnableNetwork());
    
    BroadcastList& list = (BroadcastList&)m_cData.getBroadcastList();
    BroadcastList::iterator iter = list.begin();
    
    getListStore()->clear();
    for (; iter != list.end(); iter++) {
        Gtk::TreeIter treeiter = getListStore()->append();
        treeiter->set_value(m_cColumns.BROADCAST_ADDR, *iter);
    }
}

/**
 * ǥȥ饯
 */
PropertyDialog::~PropertyDialog()
{
}

/**
 * ڡۤޤ
 */
void PropertyDialog::createBasePage(Gtk::Notebook& notebook)
{
    Gtk::Fixed* pFixed = manage(new Gtk::Fixed());
    notebook.add(*pFixed);

    notebook.set_tab_label_text
        (*(notebook.get_nth_page(0)), _("Base"));

    pFixed->put(m_cNickName, 10, 30);
    m_cNickName.set_size_request(200, 24);
    m_cNickName.set_max_length(40);

    pFixed->put(m_cBackground, 10, 80);
    m_cBackground.set_size_request(200, 24);
    m_cBackground.set_max_length(20);

    pFixed->put(m_cForeground, 10, 130);
    m_cForeground.set_size_request(200, 24);
    m_cForeground.set_max_length(20);
    
    pFixed->put(m_cFontName, 10, 180);
    m_cFontName.set_size_request(200, 24);
    m_cFontName.set_max_length(256);
    
    pFixed->put(m_cPrintCommand, 10, 230);
    m_cPrintCommand.set_size_request(350, 24);
    m_cPrintCommand.set_max_length(256);

    Gtk::Label* pLabel = manage(new Gtk::Label(_("Nickname:"), 0.0, 0.5));
    pFixed->put(*pLabel, 10, 10);
    pLabel->set_size_request(250, 16);
    pLabel->set_justify(Gtk::JUSTIFY_LEFT);

    pLabel = manage(new Gtk::Label(_("Background Color:"), 0.0, 0.5));
    pFixed->put(*pLabel, 10, 60);
    pLabel->set_size_request(250, 16);
    pLabel->set_justify(Gtk::JUSTIFY_LEFT);

    pLabel = manage(new Gtk::Label(_("Foreground Color:"), 0.0, 0.5));
    pFixed->put(*pLabel, 10, 110);
    pLabel->set_size_request(250, 16);
    pLabel->set_justify(Gtk::JUSTIFY_LEFT);

    pLabel = manage(new Gtk::Label(_("Font:"), 0.0, 0.5));
    pFixed->put(*pLabel, 10, 160);
    pLabel->set_size_request(250, 16);
    pLabel->set_justify(Gtk::JUSTIFY_LEFT);
    
    pLabel = manage(new Gtk::Label(_("Print command:"), 0.0, 0.5));
    pFixed->put(*pLabel, 10, 210);
    pLabel->set_size_request(250, 16);
    pLabel->set_justify(Gtk::JUSTIFY_LEFT);
    
    pLabel = manage(new Gtk::Label(_("    %1: Exchange to print file."), 0.0, 0.5));
    pFixed->put(*pLabel, 10, 260);
    pLabel->set_size_request(250, 16);
    pLabel->set_justify(Gtk::JUSTIFY_LEFT);

    Gtk::Button* pBgButton = manage(new Gtk::Button(_("Select..."), true));
    pFixed->put(*pBgButton, 220, 80);
    pBgButton->set_size_request(60, 24);

    Gtk::Button* pFgButton = manage(new Gtk::Button(_("Select..."), true));
    pFixed->put(*pFgButton, 220, 130);
    pFgButton->set_size_request(60, 24);

    Gtk::Button* pFnButton = manage(new Gtk::Button(_("Select..."), true));
    pFixed->put(*pFnButton, 220, 180);
    pFnButton->set_size_request(60, 24);

    pBgButton->signal_clicked().connect
        (SigC::slot(*this, &PropertyDialog::on_background_clicked));
    pFgButton->signal_clicked().connect
        (SigC::slot(*this, &PropertyDialog::on_foreground_clicked));
    pFnButton->signal_clicked().connect
        (SigC::slot(*this, &PropertyDialog::on_fontname_clicked));
}

/**
 * ͥåȥڡۤޤ
 */
void PropertyDialog::createNetworkPage(Gtk::Notebook& notebook)
{
    Gtk::Fixed* pFixed = manage(new Gtk::Fixed());
    notebook.add(*pFixed);

    notebook.set_tab_label_text
        (*(notebook.get_nth_page(1)), _("Network"));
    
    // ĥ꡼ӥ塼ι
    m_cTreeView.get_selection()->set_mode(Gtk::SELECTION_SINGLE);

    m_cListStore = Gtk::ListStore::create(m_cColumns);
    m_cTreeView.set_model(m_cListStore);
    m_cTreeView.append_column
        (_("Broadcast Address"), m_cColumns.BROADCAST_ADDR);
    
    // ڡι
    pFixed->put(m_cNetButton, 10, 10);
    m_cNetButton.set_size_request(250, 24);
    m_cNetButton.set_label(_("Enable networking."));

    Gtk::Label* pLabel =
        manage(new Gtk::Label(_("Broadcast address list:"), 0.0, 0.5));
    pFixed->put(*pLabel, 10, 40);
    pLabel->set_size_request(250, 16);
    pLabel->set_justify(Gtk::JUSTIFY_LEFT);

    pFixed->put(m_cBroadcast, 10, 60);
    m_cBroadcast.set_size_request(150, 24);

    Gtk::ScrolledWindow* pScrolledWnd = manage(new Gtk::ScrolledWindow());
    pFixed->put(*pScrolledWnd, 10, 95);
    pScrolledWnd->set_size_request(250, 150);

    pScrolledWnd->add(m_cTreeView);

    Gtk::Button* pAddButton = manage(new Gtk::Button(_("Add"), true));
    pFixed->put(*pAddButton, 170, 60);
    pAddButton->set_size_request(60, 24);
    
    Gtk::Button* pDelButton = manage(new Gtk::Button(_("Remove"), true));
    pFixed->put(*pDelButton, 270, 95);
    pDelButton->set_size_request(60, 24);

    pAddButton->signal_clicked().connect
        (SigC::slot(*this, &PropertyDialog::on_add_clicked));
    pDelButton->signal_clicked().connect
        (SigC::slot(*this, &PropertyDialog::on_remove_clicked));
}

/**
 * ꥹȥǥŪ˼ޤ
 */
Glib::RefPtr<Gtk::ListStore> PropertyDialog::getListStore()
{
    return m_cListStore;
}

/**
 * ⡼Ȥɽޤ
 * 
 * @return λɡ
 */
gint PropertyDialog::doModal()
{
    show_all_children();
    
    return run();
}

/**
 * 䵻ǡޤ
 * 
 * @return 䵻ǡ
 */
PropertyData& PropertyDialog::getNewData()
{
    return m_cData;
}

/**
 * ǡѹ̵ͭåޤ
 * 
 * @return ѹ true ᤷޤ
 */
bool PropertyDialog::isChanged()
{
    return (m_cData != m_cOriginalData);
}

/**
 * ɥκ׵ޤ
 */
bool PropertyDialog::on_delete_event(GdkEventAny* pEvent)
{
    on_response(Gtk::RESPONSE_CANCEL);
    
    return true;
}

/**
 * 쥹ݥ
 */
void PropertyDialog::on_response(int nResponse)
{
    m_nResponse = nResponse;
    
    if (Gtk::RESPONSE_OK == nResponse) {
        // ͤΥå
        Gdk::Color bgColor;
        Gdk::Color fgColor;
        
        if (!bgColor.parse(m_cBackground.get_text())) {
            Gtk::MessageDialog msgdlg(_("Can't parse background color."),
                Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true, false);
            
            msgdlg.run();
            return;
        }
        if (!fgColor.parse(m_cForeground.get_text())) {
            Gtk::MessageDialog msgdlg(_("Can't parse foreground color."),
                Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true, false);
                
            msgdlg.run();
            return;
        }
        
        m_cData.setNickName(m_cNickName.get_text().c_str());
        m_cData.setBackground(bgColor.gobj());
        m_cData.setForeground(fgColor.gobj());
        m_cData.setFontName(m_cFontName.get_text().c_str());
        m_cData.setEnableNetwork(m_cNetButton.get_active());
        m_cData.setPrintCommand(m_cPrintCommand.get_text().c_str());
        
        Gtk::TreeIter iter = getListStore()->children().begin();
        Gtk::TreeIter enditer = getListStore()->children().end();
        
        m_cData.clearBroadcastList();
        for (; iter != enditer; iter++) {
            m_cData.addBroadcastAddr
                (iter->get_value(m_cColumns.BROADCAST_ADDR));
        }
    }
    
    Gtk::Dialog::on_response(nResponse);
}

/**
 * طʿ
 */
void PropertyDialog::on_background_clicked()
{
    Gtk::ColorSelectionDialog colordlg;
    
    colordlg.set_title(_("Background Color:"));
    colordlg.set_transient_for(*this);
    colordlg.get_help_button()->hide();

    Gdk::Color bgColor;
    bgColor.parse(m_cBackground.get_text());
    colordlg.get_colorsel()->set_current_color(bgColor);
    
    if (Gtk::RESPONSE_OK == colordlg.run()) {
        Gdk::Color newColor = colordlg.get_colorsel()->get_current_color();
        gchar buf[1024] = {0};
        
        memset(buf, '\0', sizeof(buf));
        snprintf(buf, sizeof(buf) -1, "#%02X%02X%02X", 
            (int)rint(newColor.get_red_p() * 0xff),
            (int)rint(newColor.get_green_p() * 0xff),
            (int)rint(newColor.get_blue_p() * 0xff));
        m_cBackground.set_text(buf);
    }
}

/**
 * ʿ
 */
void PropertyDialog::on_foreground_clicked()
{
    Gtk::ColorSelectionDialog colordlg;
    
    colordlg.set_title(_("Foreground Color:"));
    colordlg.set_transient_for(*this);
    colordlg.get_help_button()->hide();

    Gdk::Color fgColor;
    fgColor.parse(m_cForeground.get_text());
    colordlg.get_colorsel()->set_current_color(fgColor);
    
    if (Gtk::RESPONSE_OK == colordlg.run()) {
        Gdk::Color newColor = colordlg.get_colorsel()->get_current_color();
        gchar buf[1024] = {0};
        
        memset(buf, '\0', sizeof(buf));
        snprintf(buf, sizeof(buf) -1, "#%02X%02X%02X", 
            (int)rint(newColor.get_red_p() * 0xff),
            (int)rint(newColor.get_green_p() * 0xff),
            (int)rint(newColor.get_blue_p() * 0xff));
        m_cForeground.set_text(buf);
    }
}

/**
 * եȤ
 */
void PropertyDialog::on_fontname_clicked()
{
    Gtk::FontSelectionDialog fontdlg;
    
    fontdlg.set_title(_("Font:"));
    fontdlg.set_transient_for(*this);
    fontdlg.get_apply_button()->hide();
    
    fontdlg.get_font_selection()->set_font_name(m_cFontName.get_text());
    
    if (Gtk::RESPONSE_OK == fontdlg.run()) {
        m_cFontName.set_text(fontdlg.get_font_selection()->get_font_name());
    }
}

/**
 * ɲåܥβ
 */
void PropertyDialog::on_add_clicked()
{
    Glib::ustring addr = m_cBroadcast.get_text();
    struct in_addr in;

    if (inet_aton(addr.c_str(), &in)) {
        Gtk::TreeIter treeiter = getListStore()->append();
        treeiter->set_value(m_cColumns.BROADCAST_ADDR, addr);
    }
    else {
        Glib::ustring msg = _("'' is not broadcast address.");
        msg.insert(1, addr);

        Gtk::MessageDialog dialog
            (msg, Gtk::MESSAGE_ERROR,
             Gtk::BUTTONS_OK, true, false);

        dialog.set_transient_for(*this);

        dialog.run();
    }
}

/**
 * ܥβ
 */
void PropertyDialog::on_remove_clicked()
{
    Gtk::TreeIter treeiter = m_cTreeView.get_selection()->get_selected();

    if (treeiter) {
        getListStore()->erase(treeiter);
    }
}
