/*
 * $Id: propertydialog.h,v 1.1 2004/04/01 08:53:26 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#ifndef ___PROPERTYDIALOG_H
#define ___PROPERTYDIALOG_H

#include <gtkmm.h>
#include "../include/propertydata.h"

class PropertyDialog : public Gtk::Dialog
{
public:
    /**
     * 󥹥ȥ饯
     */
    PropertyDialog(const PropertyData& property);

    /**
     * ǥȥ饯
     */
    virtual ~PropertyDialog();

    /**
     * ꥹȥǥŪ˼ޤ
     */
    Glib::RefPtr<Gtk::ListStore> getListStore();

    /**
     * ⡼Ȥɽޤ
     * 
     * @return 쥹ݥ
     */
    gint doModal();
    
    /**
     * 䵻ǡޤ
     * 
     * @return 䵻ǡ
     */
    PropertyData& getNewData();
    
    /**
     * ǡѹ̵ͭåޤ
     * 
     * @return ѹ true ᤷޤ
     */
    bool isChanged();
    
protected:
    /**
     * ɥκ׵ޤ
     */
    virtual bool on_delete_event(GdkEventAny* pEvent);

    /**
     * 쥹ݥ
     */
    virtual void on_response(int nResponse);

    /**
     * طʿ
     */
    virtual void on_background_clicked();
    
    /**
     * ʿ
     */
    virtual void on_foreground_clicked();
    
    /**
     * եȤ
     */
    virtual void on_fontname_clicked();
    
    /**
     * ɲåܥβ
     */
    virtual void on_add_clicked();
    
    /**
     * ܥβ
     */
    virtual void on_remove_clicked();
    
private:
    /**
     * ڡۤޤ
     */
    void createBasePage(Gtk::Notebook& notebook);

    /**
     * ͥåȥڡۤޤ
     */
    void createNetworkPage(Gtk::Notebook& notebook);

private:
    /**
     * ݻ饹
     */
    class ModelColumns : public Gtk::TreeModel::ColumnRecord
    {
    public:
        Gtk::TreeModelColumn<Glib::ustring>  BROADCAST_ADDR;
    
        ModelColumns() { add(BROADCAST_ADDR); }
    };

public:
    /**
     * 
     */
    const ModelColumns m_cColumns;

private:
    /**
     * ꥸʥ䵻ǡ
     */
    PropertyData m_cOriginalData;
    
    /**
     * 䵻ǡ
     */
    PropertyData m_cData;
    
    /**
     * 쥹ݥ
     */
    int m_nResponse;
    
    /**
     * ˥å͡
     */
    Gtk::Entry m_cNickName;
    
    /**
     * طʿ
     */
    Gtk::Entry m_cBackground;
    
    /**
     * ʿ
     */
    Gtk::Entry m_cForeground;
    
    /**
     * ե̾
     */
    Gtk::Entry m_cFontName;
    
    /**
     * ͥåȥͭե饰
     */
    Gtk::CheckButton m_cNetButton;
    
    /**
     * ޥ
     */
    Gtk::Entry m_cPrintCommand;
    
    /**
     * ֥ɥ㥹ȥɥ쥹ϥȥ
     */
    Gtk::Entry m_cBroadcast;

    /**
     * ĥ꡼ӥ塼
     */
    Gtk::TreeView m_cTreeView;
    
    /**
     * ĥ꡼ӥ塼Υꥹȥǥ
     */
    Glib::RefPtr<Gtk::ListStore> m_cListStore;
};

#endif
