/*
 * $Id: senddialog.cpp,v 1.1 2004/04/01 08:53:26 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "wndservice.h"
#include "senddialog.h"

static gint onUpdateServerlist(gpointer data);

/**
 * 󥹥ȥ饯
 */
SendDialog::SendDialog()
{
    set_title(_("Fusenshi - Send"));
    set_wmclass(APP_NAME, "SendDialog");
    set_modal(true);
    property_destroy_with_parent() = true;

    m_nClients = 0;

    // ĥ꡼ӥ塼ι
    m_cTreeView.get_selection()->set_mode(Gtk::SELECTION_MULTIPLE);

    m_cListStore = Gtk::ListStore::create(m_cColumns);
    m_cTreeView.set_model(m_cListStore);
    m_cTreeView.append_column(_("UserName"), m_cColumns.USERNAME);
    m_cTreeView.append_column(_("HostName"), m_cColumns.HOSTNAME);
    m_cTreeView.append_column(_("IPAddress"), m_cColumns.IPADDR);

    // ɥι
    Gtk::Fixed* pFixed = manage(new Gtk::Fixed());
    get_vbox()->pack_start(*pFixed, true, true, 0);

    Gtk::Label* pLabel = manage(new Gtk::Label(_("Send To:")));
    pFixed->put(*pLabel, 0, 8);
    pLabel->set_size_request(60, 16);
    pLabel->set_justify(Gtk::JUSTIFY_LEFT);

    Gtk::ScrolledWindow* pScrolledWnd = manage(new Gtk::ScrolledWindow());
    pFixed->put(*pScrolledWnd, 8, 32);
    pScrolledWnd->set_size_request(416, 136);

    pScrolledWnd->add(m_cTreeView);

    Gtk::Button* pButton = manage(new Gtk::Button());
    pFixed->put(*pButton, 440, 136);
    pButton->set_size_request(80, 32);

    Gtk::Alignment* pAlignment = manage(new Gtk::Alignment(0.5, 0.5, 0, 0));
    pButton->add(*pAlignment);

    Gtk::HBox* pHBox = manage(new Gtk::HBox(false, 2));
    pAlignment->add(*pHBox);

    Gtk::StockID stockid("gtk-refresh");
    Gtk::Image* pImage = manage(new Gtk::Image(stockid, Gtk::ICON_SIZE_BUTTON));
    pHBox->pack_start(*pImage, false, false, 0);

    pLabel = manage(new Gtk::Label(_("Update")));
    pHBox->pack_end(*pLabel, false, false, 0);
    pLabel->set_justify(Gtk::JUSTIFY_LEFT);

    pButton->signal_clicked().connect
        (SigC::slot(*this, &SendDialog::on_refresh_clicked));

    get_action_area()->set_layout(Gtk::BUTTONBOX_END);

    stockid = Gtk::StockID("gtk-cancel");
    pButton = manage(new Gtk::Button(stockid));
    add_action_widget(*pButton, Gtk::RESPONSE_CANCEL);
    pButton->set_flags(Gtk::CAN_DEFAULT);

    stockid = Gtk::StockID("gtk-ok");
    pButton = manage(new Gtk::Button(stockid));
    add_action_widget(*pButton, Gtk::RESPONSE_OK);
    pButton->set_flags(Gtk::CAN_DEFAULT);
    
    pButton->signal_clicked().connect
        (SigC::slot(*this, &SendDialog::on_ok_clicked));

    show_all_children();
    
    // ꥯȤ
    on_refresh_clicked();
    
    // 䵻極СɽѤΥޡư
    m_nTimer = gtk_timeout_add
       (500 /* 1sec */, (GtkFunction)onUpdateServerlist, this);
}

/**
 * ǥȥ饯
 */
SendDialog::~SendDialog()
{
    gtk_timeout_remove(m_nTimer);
}

/**
 * ꥹȥǥŪ˼ޤ
 */
Glib::RefPtr<Gtk::ListStore> SendDialog::getListStore()
{
    return m_cListStore;
}

/**
 * 䵻極аޤ
 * 
 * @return 䵻極а
 */
ServerList& SendDialog::getServerList()
{
    return m_cServerList;
}

/**
 * OKܥ󲡲
 */
void SendDialog::on_ok_clicked()
{
    // 򤷤Ƥ
    m_cTreeView.get_selection()->selected_foreach
        (SigC::slot(*this, &SendDialog::on_selected_foreach));
}

/**
 * ܥ󲡲
 */
void SendDialog::on_refresh_clicked()
{
    // 
    FusenshiServerInfo* pServerInfo = FusenshiServerInfo::getInstance();
    
    if (pServerInfo) {
        pServerInfo->getServerList().clear();
    }
    getListStore()->clear();
    m_nClients = 0;
    
    // ꥯȤ
    FusenshiClient::sendServerInfoRequest(WndService::getProperty());
}

/**
 * 򤷤ޤ
 */
void SendDialog::on_selected_foreach(const Gtk::TreeModel::iterator& iter)
{
    m_cServerList.add((*iter)[m_cColumns.USERNAME],
                      (*iter)[m_cColumns.HOSTNAME],
                      (*iter)[m_cColumns.IPADDR]);
}

/**
 * 䵻極Сιޡ
 */
static gint onUpdateServerlist(gpointer data)
{
    SendDialog *pDialog = (SendDialog*)data;

    if (NULL == pDialog || !pDialog->is_mapped()) {
        return FALSE; // Stop Timer
    }

    // ĥ꡼
    FusenshiServerInfo* pServerInfo = FusenshiServerInfo::getInstance();
    
    if (pServerInfo) {
        ServerList& serverList = pServerInfo->getServerList();
        
        serverList.lockList();
        
        std::list<Glib::ustring>& username = serverList.getUserNameList();
        std::list<Glib::ustring>& hostname = serverList.getHostNameList();
        std::list<Glib::ustring>& ipaddr = serverList.getIPAddrList();
        
        std::list<Glib::ustring>::iterator uiter;
        std::list<Glib::ustring>::iterator hiter;
        std::list<Glib::ustring>::iterator iiter;
        
        uiter = username.begin();
        hiter = hostname.begin();
        iiter = ipaddr.begin();
        
        for (int count = 0; iiter != ipaddr.end();
             uiter++, hiter++, iiter++, count++)
        {
            if (count < pDialog->m_nClients) continue;

            // ɲä
            Gtk::TreeIter treeiter = pDialog->getListStore()->append();
            treeiter->set_value(pDialog->m_cColumns.USERNAME, *uiter);
            treeiter->set_value(pDialog->m_cColumns.HOSTNAME, *hiter);
            treeiter->set_value(pDialog->m_cColumns.IPADDR, *iiter);
            
            pDialog->m_nClients++;
        }
        
        serverList.unlockList();
    }
    
    return TRUE;
}
