/*
 * $Id: senddialog.h,v 1.1 2004/04/01 08:53:26 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#ifndef ___SENDDIALOG_H
#define ___SENDDIALOG_H

#include "gtkmm.h"
#include "../include/serverlist.h"

class SendDialog : public Gtk::Dialog
{
public:
    /**
     * 󥹥ȥ饯
     */
    SendDialog();
    
    /**
     * ǥȥ饯
     */
    virtual ~SendDialog();
    
    /**
     * ꥹȥǥŪ˼ޤ
     */
    Glib::RefPtr<Gtk::ListStore> getListStore();
    
    /**
     * 䵻極аޤ
     * 
     * @return 䵻極а
     */
    ServerList& getServerList();
    
protected:
    /**
     * OKܥ󲡲
     */
    virtual void on_ok_clicked();

    /**
     * ܥ󲡲
     */
    virtual void on_refresh_clicked();
    
    /**
     * 򤷤ޤ
     */
    virtual void on_selected_foreach(const Gtk::TreeModel::iterator& iter);
    
private:
    /**
     * ݻ饹
     */
    class ModelColumns : public Gtk::TreeModel::ColumnRecord
    {
    public:
        Gtk::TreeModelColumn<Glib::ustring>  USERNAME;
        Gtk::TreeModelColumn<Glib::ustring>  HOSTNAME;
        Gtk::TreeModelColumn<Glib::ustring>  IPADDR;
    
        ModelColumns() { add(USERNAME); add(HOSTNAME); add(IPADDR); }
    };

public:
    /**
     * 
     */
    const ModelColumns m_cColumns;

    /**
     * ɽΥ饤Ȥ
     */
    int m_nClients;

private:
    /**
     * ͥåȥ
     */
    ServerList m_cServerList;
    
    /**
     * ޡֹ
     */
    gint m_nTimer;
    
    /**
     * ĥ꡼ӥ塼
     */
    Gtk::TreeView m_cTreeView;
    
    /**
     * ĥ꡼ӥ塼Υꥹȥǥ
     */
    Glib::RefPtr<Gtk::ListStore> m_cListStore;
};

#endif
