/*
 * $Id: wnd.cpp,v 1.1 2004/04/01 08:53:26 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"

#include "wndservice.h"
#include "fusenshimainwnd.h"
#include "fusenshiwnd.h"

#include <gtkmm.h>
#include <signal.h>

static void sigTerm(int num);
static void sigPipe(int num);

static gpointer doServiceThread(gpointer data);

/**
 * ɥץ򳫻Ϥޤ
 * 
 * @param inFD եI/OץȤΥѥ
 * @param outFD եI/OץȤΥѥ
 * @param lpWndGlobalProp ɥ
 */
void windowServiceStart(int inFD, int outFD,
                        LP_WND_GLOBAL_PROP lpWndGlobalProp)
{
    // gtk2Υ꥽եɲ
    char rcfile[PATH_MAX] = {0};
    
    strncpy(rcfile, getAppDir(APP_NAME), sizeof(rcfile) -1);
    strncat(rcfile, "/gtkrc", sizeof(rcfile) -1);
    gtk_rc_add_default_file(rcfile);
    
    // gtk2ν
    Gtk::Main gMain(NULL, NULL, true);
    
    // gthread ν    
    if (!g_thread_supported()) g_thread_init(NULL);

    try {
        // 䵻楦ɥν
        FusenshiWnd::setDefaultWindowType(lpWndGlobalProp->wndType);
        
        // ȥåץ٥륦ɥι
        FusenshiMainWnd *pMainWnd = new FusenshiMainWnd();
        
        if (!pMainWnd) {
            throw "Can't create top level window.";
        }
        
        // ɽ֤Ĵ
        if(0 > lpWndGlobalProp->initWndPosX){
            lpWndGlobalProp->initWndPosX += gdk_screen_width();
            lpWndGlobalProp->initWndPosX -= TOP_WINDOW_WIDTH;
        }
        if(0 > lpWndGlobalProp->initWndPosY){
            lpWndGlobalProp->initWndPosY += gdk_screen_height();
            lpWndGlobalProp->initWndPosY -= TOP_WINDOW_HEIGHT;
        }

        pMainWnd->move(lpWndGlobalProp->initWndPosX,
                       lpWndGlobalProp->initWndPosY);
        pMainWnd->show();
        
        // ɥ饹ι
        WndService* wndService = WndService::getInstance(inFD, outFD);
        
        if (!wndService) {
            delete pMainWnd;
            throw "Out Of Memory Error!";
        }

        // ʥϥɥ
        signal(SIGTERM, sigTerm);
        signal(SIGPIPE, sigPipe);
        
        // ̿򳫻Ϥ
        GThread *pThread =
            g_thread_create(doServiceThread, NULL, TRUE, NULL);
        
        if (!pThread) {
            delete pMainWnd;
            throw "Can't create thread!";
        }
        
        // λԤ
        wndService->waitFor();
        g_thread_join(pThread);
        
        // 
        delete pMainWnd;

        WndService::destroy();
        FusenshiServerInfo::destroy();
    }
    catch (char* pMessage) {
        fprintf(stderr, "%s: WND: %s\n", APP_NAME, pMessage);
    }
    catch (const char* pMessage) {
        fprintf(stderr, "%s: WND: %s\n", APP_NAME, pMessage);
    }
    catch (...) {
        fprintf(stderr, "%s: WND: Unknown exception occured.\n", APP_NAME);
    }
}

/**
 * ɥӥμ¹ԥå
 */
static gpointer doServiceThread(gpointer data)
{
    try {
        WndService::getInstance()->run();
    }
    catch (char* pMessage) {
        fprintf(stderr, "%s: WND: %s\n", APP_NAME, pMessage);
    }
    catch (const char* pMessage) {
        fprintf(stderr, "%s: WND: %s\n", APP_NAME, pMessage);
    }
    catch (...) {
        fprintf(stderr, "%s: WND: Unknown exception occured.\n", APP_NAME);
    }
    
    return NULL;
}

/**
 * SIGTERM ʥα
 */
static void sigTerm(int num)
{
    try {
        WndService::getInstance()->stop();
    }
    catch (char* pMessage) {
        fprintf(stderr, "%s: WND: %s\n", APP_NAME, pMessage);
    }
    catch (const char* pMessage) {
        fprintf(stderr, "%s: WND: %s\n", APP_NAME, pMessage);
    }
    catch (...) {
        fprintf(stderr, "%s: WND: Unknown exception occured.\n", APP_NAME);
    }
}

/**
 * SIGPIPE ʥα
 */
static void sigPipe(int num)
{
    sigTerm(num);
}
