/*
 * $Id: wndservice.cpp,v 1.1 2004/04/01 08:53:26 daichi Exp $
 *g
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "wndservice.h"

#include <sys/select.h>
#include <signal.h>

/**
 * ͣΥ󥹥
 */
WndService* WndService::m_pInstance = NULL;

/**
 * 䵻
 */
PropertyData WndService::m_cProperty;

/**
 * 󥹥ȥ饯
 */
WndService::WndService(int inFD, int outFD)
{
    m_nIn = inFD;
    m_nOut = outFD;
    m_bStop = FALSE;
    m_bRunning = FALSE;
    m_pCommand = new CommandControl();
    
    if (!m_pCommand) {
        throw "Out of Memory Error!";
    }
    
    m_pMutex = g_mutex_new();
    
    if (!m_pMutex) {
        throw "Can't create mutex!";
    }
}

/**
 * ǥȥ饯
 */
WndService::~WndService()
{
    if (m_bRunning) {
        stop();
    }
    
    if (m_pCommand) {
        delete m_pCommand;
    }

    // Ƥ䵻楦ɥ˴ꥹȤɲá
    destroyFusenshiWndAll();
    
    // ˴оݤ䵻ľ˴롣
    doDestroy();
    
    if (m_pMutex) {
        g_mutex_free(m_pMutex);
    }
}

/**
 * 䵻եιۤեI/Oץ׵ᤷޤ
 */
void WndService::createFusenshi()
{
    m_pCommand->addCommand(CREATE_NEW_FUSENSHI, 0, NULL);
}

/**
 * 䵻ե˴եI/Oץ׵ᤷޤ
 * 
 * @param nFileID եID
 */
void WndService::deleteFusenshi(guint nFileID)
{
    m_pCommand->addCommand(DELETE_FUSENSHI, nFileID, NULL);
}

/**
 * 䵻եΰեI/Oץ׵ᤷޤ
 * 
 * @param nFileID եID
 * @param szCommand ޥ
 */
void WndService::printFusenshi(guint nFileID, Glib::ustring& szCommand)
{
    GString* pCommand = g_string_new(szCommand.c_str());

    if (pCommand) {
        m_pCommand->addCommand(PRINT_FUSENSHI, nFileID, (gpointer)pCommand);
    }
    else {
        throw "Out of Memory Error!";
    }
}

/**
 * 䵻եιեI/Oץ׵ᤷޤ
 * 
 * @param nFileID եID
 * @param pData 䵻ǡ
 */
void WndService::saveFusenshi(guint nFileID, const FusenshiData* pData)
{
    GString* pStrData = FusenshiData::toSerializedString(pData);
    
    if (pStrData) {
        m_pCommand->addCommand(SAVE_FUSENSHI, nFileID, (gpointer)pStrData);
    }
    else {
        throw "Out of Memory Error!";
    }
}

/**
 * ̿򳫻Ϥޤ
 */
void WndService::run()
{
    // ¹Ծ֤γǧ
    int bRunning = FALSE;
    
    g_mutex_lock(m_pMutex);
    bRunning = m_bRunning;
    if (!m_bRunning) {
        m_bRunning = TRUE;
    }
    m_bStop = FALSE;
    g_mutex_unlock(m_pMutex);
    
    if (bRunning) {
        throw "WndService is already running.";
    }
    
    // ¹Գ
    int bStop = FALSE;
    LP_COMMAND lpCommand = NULL;
    Gtk::Main* pMain = Gtk::Main::instance();
    
    // ץѥƥư
    WndService::updateProperty();

    try {
        while (!bStop) {
            // եI/Oץ׵å
            lpCommand = m_pCommand->receiveCommand(m_nIn);
            
            if (lpCommand) {
                actionCommand(lpCommand);
                m_pCommand->destroyCommand(lpCommand);
            }
    
            // եI/Oץؤޥɤ̵ͭǧ
            lpCommand = m_pCommand->getCommand();
            
            if (lpCommand) {
                m_pCommand->sendCommand(m_nOut, lpCommand);
                m_pCommand->destroyCommand(lpCommand);
            }
            
            // Gtk¹
            while (pMain->events_pending()) {
                pMain->iteration();
            }
            
            // ˴оݤ䵻򤹤˴
            doDestroy();
            
            // λ׵å
            g_mutex_lock(m_pMutex);
            bStop = m_bStop;
            g_mutex_unlock(m_pMutex);
        }
        
        // ץꥱνλΤ
        COMMAND exitCommand = {EXIT_APP, 0, NULL};
        m_pCommand->sendCommand(m_nOut, &exitCommand);
    }
    catch (char* pErrorMsg) {
        fprintf(stderr, "%s: WndService: %s\n", APP_NAME, pErrorMsg);
    }
    catch (const char* pErrorMsg) {
        fprintf(stderr, "%s: WndService: %s\n", APP_NAME, pErrorMsg);
    }
    catch (...) {
        fprintf(stderr, "%s: WndService: unknown error.\n", APP_NAME);
    }
    
    // λ
    g_mutex_lock(m_pMutex);
    m_bRunning = FALSE;
    m_bStop = FALSE;
    g_mutex_unlock(m_pMutex);
    
    // Ƥ䵻̾夫˴
    destroyFusenshiWndAll();
    doDestroy();
}

/**
 * ̿λޤ
 */
void WndService::stop()
{
    g_mutex_lock(m_pMutex);
    
    if (m_bRunning) {
        m_bStop = TRUE;
    }

    g_mutex_unlock(m_pMutex);
}

/**
 * ̿δλԤޤ
 */
void WndService::waitFor()
{
    int bEnable = TRUE;
    
    while (bEnable) {
        g_mutex_lock(m_pMutex);
        bEnable = m_bRunning;
        g_mutex_unlock(m_pMutex);
        
        if (bEnable) {
            usleep(250 * 1000 /* 250ms*/);
        }
    }
}

/**
 * 󥹥󥹤˴ץꥱνλ
 * Ԥޤ
 */
void WndService::destroy()
{
    WndService* instance = getInstance();
    
    if (instance) {
        instance->stop();
        instance->waitFor();
        
        delete instance;
        m_pInstance = NULL;
    }
}

/**
 * ۺѤWndService饹Υ󥹥󥹤ޤ
 * 
 * @return ͣΥ󥹥
 */
WndService* WndService::getInstance()
{
    if (!m_pInstance) {
        throw "WndService has no Instance.";
    }
    
    return m_pInstance;
}

/**
 * ɬפ˱WndService饹Υ󥹥󥹤ۤ
 * ͣΥ󥹥󥹤ޤ
 * 
 * @param inFD ɥץȤΥѥ
 * @param outFD ɥץȤΥѥ
 * @return ͣΥ󥹥
 */
WndService* WndService::getInstance(int inFD, int outFD)
{
    if (!m_pInstance) {
        m_pInstance = new WndService(inFD, outFD);
        
        if (!m_pInstance) {
            throw "Out of Memory Error!";
        }
    }
    
    return m_pInstance;
}

/**
 * 䵻ޤ
 * 
 * @return 䵻
 */
PropertyData WndService::getProperty()
{
    static bool bLoad = false;

    if (!bLoad) {
        try {
            WndService::m_cProperty = PropertyData::loadProperty();
        }
        catch (...) {
            fprintf(stderr, "%s: Can't load property file.", APP_NAME);
        }

        bLoad = true;
    }

    return WndService::m_cProperty;
}

/**
 * 䵻ꤷľݴɤޤ
 * 
 * @param property 䵻
 */
void WndService::setProperty(const PropertyData& property)
{
    if (!PropertyData::saveProperty(property)) {
        fprintf(stderr, "%s: Can't save property file.", APP_NAME);
    }
    else {
        // ݻ
        WndService::m_cProperty = property;

        // ѹȿ
        WndService::updateProperty();

        // ѹΤ
        WndService *pInstance = WndService::getInstance();
        pInstance->m_pCommand->addCommand(PROPERTY_CHANGED, 0, NULL);
    }
}

/**
 * ץѥƥѹɬפʽ¹Ԥޤ
 */
void WndService::updateProperty()
{
    PropertyData property = WndService::getProperty();

#ifndef WITHOUT_NETWORK
    // ͥåȥ̵ͭĴ
    if (property.isEnableNetwork()) {
        FusenshiServerInfo *pSrvInfo = FusenshiServerInfo::getInstance();

        if (pSrvInfo) {
            // ˥å͡
            pSrvInfo->setNickName(property.getNickName());
        }
        else {
            fprintf(stderr,
                    "%s: Can't start network information server.\n",
                    APP_NAME);
        }
    }
    else {
        FusenshiServerInfo::destroy();
    }
#endif
}

/**
 * ޥɤޤ
 * 
 * @param lpCommand ޥ
 */
void WndService::actionCommand(LP_COMMAND lpCommand)
{
    GString* pString = NULL;
    NetworkFusenshiData* pData = NULL;
    
    switch (lpCommand->nCommandID) {
    case CREATE_NEW_FUSENSHI_WINDOW:
        pString = (GString*)lpCommand->pData;
        createFusenshiWnd
            (FusenshiData::buildObject(pString), lpCommand->nFileID);
        break;
    case VERIFY_RECEIVE_DATA:
        pString = (GString*)lpCommand->pData;
        pData = (NetworkFusenshiData*)
            NetworkFusenshiData::buildObject(pString);

        // γǧ
        if (Gtk::RESPONSE_OK == verifyReceive(pData)) {
            createFusenshiWnd(pData, lpCommand->nFileID);
        }
        else {
            deleteFusenshi(lpCommand->nFileID);
        }
        break;
    case PROPERTY_CHANGED:
        WndService::m_cProperty = PropertyData::loadProperty();
        WndService::updateProperty();
        break;
    default:
        break;
    }
}

/**
 * 䵻楦ɥޤ
 * 
 * @param pData 䵻
 *              䵻楦ɥǴ뤿ᡢ˴Ǥޤ
 * @param nFileID ե륤ǥå
 */
void WndService::createFusenshiWnd(FusenshiData *pData, guint nFileID)
{
    g_mutex_lock(m_pMutex);

    // 
    FusenshiWnd* pWnd = new FusenshiWnd(pData, nFileID);
    
    if (!pWnd) {
        throw "Out of Memory Error.";
    }
    
    // ɽ
    pWnd->show();

    // ɥΰɲ
    m_cWndList.push_back(pWnd);

    g_mutex_unlock(m_pMutex);
}

/**
 * 䵻楦ɥ˴ޤ
 */
void WndService::destroyFusenshiWnd(FusenshiWnd *pWnd)
{
    g_mutex_lock(m_pMutex);
    m_cWndList.remove(pWnd);
    m_cDELWndList.push_back(pWnd);
    g_mutex_unlock(m_pMutex);
}

/**
 * 䵻楦ɥ˴ޤ
 */
void WndService::destroyFusenshiWndAll()
{
    FusenshiWndList::iterator iter;

    g_mutex_lock(m_pMutex);

    iter = m_cWndList.begin();
    for (; m_cWndList.end() != iter; iter++) {
        m_cDELWndList.push_back(*iter);
    }

    m_cWndList.clear();

    g_mutex_unlock(m_pMutex);
}

/**
 * ˴оݤ䵻楦ɥľ˴ޤ
 */
void WndService::doDestroy()
{
    FusenshiWndList::iterator iter;

    g_mutex_lock(m_pMutex);
    
    iter = m_cDELWndList.begin();
    for (; m_cDELWndList.end() != iter; iter++) {
        if (*iter) {
            delete (*iter);
        }
    }
    
    m_cDELWndList.clear();

    g_mutex_unlock(m_pMutex);
}

/**
 * 䵻򳫤Ƥɤˬͤޤ
 * 
 * @param pData 䵻ǡ
 * @return Ƥɤ Gtk::RESPONSE_OK ᤷޤ
 */
gint WndService::verifyReceive(const NetworkFusenshiData* pData)
{
    gchar buf[4096];

    memset(buf, '\0', sizeof(buf));
    snprintf(buf, sizeof(buf)-1,
             _("I recieved note from follow:\n"
               "Username: %s\n"
               "Hostname: %s\n"
               "IP Address: %s\n"
               "Shall I open?"),
             pData->getUserName().c_str(),
             pData->getHostName().c_str(),
             pData->getIPAddr().c_str());

    // γǧ
    Gtk::MessageDialog dialog
        (buf,
         Gtk::MESSAGE_QUESTION,
         Gtk::BUTTONS_OK_CANCEL, true, false);

    dialog.set_position(Gtk::WIN_POS_CENTER);
    dialog.set_default_response(Gtk::RESPONSE_OK);

    return dialog.run();
}
