/*
 * $Id: wndservice.h,v 1.1 2004/04/01 08:53:26 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#ifndef ___WNDSERVICE_H
#define ___WNDSERVICE_H

#include "glib.h"
#include "../include/commandid.h"
#include "../include/commandcontrol.h"
#include "../include/fusenshidata.h"
#include "../include/networkfusenshidata.h"
#include "../include/propertydata.h"
#include "fusenshiwnd.h"

typedef std::list<FusenshiWnd*> FusenshiWndList;

class WndService
{
public:
    /**
     * 䵻եιۤեI/Oץ׵ᤷޤ
     */
    void createFusenshi();
    
    /**
     * 䵻ե˴եI/Oץ׵ᤷޤ
     * 
     * @param nFileID եID
     */
    void deleteFusenshi(guint nFileID);
    
    /**
     * 䵻楦ɥ˴ޤ
     * 
     * @param pWnd 䵻楦ɥ
     */
    void destroyFusenshiWnd(FusenshiWnd *pWnd);

    /**
     * 䵻楦ɥ˴ޤ
     */
    void destroyFusenshiWndAll();
    
    /**
     * 䵻եΰեI/Oץ׵ᤷޤ
     * 
     * @param nFileID եID
     * @param szCommand ޥ
     */
    void printFusenshi(guint nFileID, Glib::ustring& szCommand);

    /**
     * 䵻եιեI/Oץ׵ᤷޤ
     * 
     * @param nFileID եID
     * @param pData 䵻ǡ
     */
    void saveFusenshi(guint nFileID, const FusenshiData* pData);
    
    /**
     * ̿򳫻Ϥޤ
     */
    void run();
    
    /**
     * ̿λޤ
     */
    void stop();
    
    /**
     * ̿δλԤޤ
     */
    void waitFor();
    
public:
    /**
     * 󥹥󥹤˴ץꥱνλ
     * Ԥޤ
     */
    static void destroy();
    
    /**
     * ۺѤWndService饹Υ󥹥󥹤ޤ
     * 
     * @return ͣΥ󥹥
     */
    static WndService* getInstance();
    
    /**
     * ɬפ˱WndService饹Υ󥹥󥹤ۤ
     * ͣΥ󥹥󥹤ޤ
     * 
     * @param inFD ɥץȤΥѥ
     * @param outFD ɥץȤΥѥ
     * @return ͣΥ󥹥
     */
    static WndService* getInstance(int inFD, int outFD);
    
    /**
     * 䵻ޤ
     * 
     * @return 䵻
     */
    static PropertyData getProperty();
    
    /**
     * 䵻ꤷľݴɤޤ
     * 
     * @param property 䵻
     */
    static void setProperty(const PropertyData& property);

public:
    /**
     * ǥȥ饯
     */
    ~WndService();
    
private:
    /**
     * 󥹥ȥ饯
     */
    WndService(int inFD, int outFD);

    /**
     * ޥɤޤ
     * 
     * @param lpCommand ޥ
     */
    void actionCommand(LP_COMMAND lpCommand);

    /**
     * 䵻楦ɥޤ
     * 
     * @param pData 䵻
     *              䵻楦ɥǴ뤿ᡢ˴Ǥޤ
     * @param nFileID ե륤ǥå
     */
    void createFusenshiWnd(FusenshiData *pData, guint nFileID);

    /**
     * ˴оݤ䵻楦ɥľ˴ޤ
     */
    void doDestroy();
    
    /**
     * 䵻򳫤Ƥɤˬͤޤ
     * 
     * @param pData 䵻ǡ
     * @return Ƥɤ Gtk::RESPONSE_OK ᤷޤ
     */
    gint verifyReceive(const NetworkFusenshiData* pData);

private:
    /**
     * ץѥƥѹɬפʽ¹Ԥޤ
     */
    static void updateProperty();

private:
    /**
     * ͣΥ󥹥
     */
    static WndService* m_pInstance;
    
    /**
     * 䵻
     */
    static PropertyData m_cProperty;
    
    /**
     * ¦ѥ
     */
    int m_nIn;
    
    /**
     * ¦ѥ
     */
    int m_nOut;
    
    /**
     * ̿¹Ծ
     */
    int m_bRunning;
    
    /**
     * ̿׵ե饰
     */
    int m_bStop;
    
    /**
     * Ʊѥߥ塼ƥå
     */
    GMutex* m_pMutex;
    
    /**
     * ޥ饹
     */
    CommandControl* m_pCommand;
    
    /**
     * 䵻楦ɥ
     */
    FusenshiWndList m_cWndList;
    
    /**
     * ˴оݤ䵻楦ɥ
     */
    FusenshiWndList m_cDELWndList;
};

#endif
