#ifndef __Area_h__
#define __Area_h__

#include <tinyxml.h>

#include <string>
using namespace std;

#include "FVectors.h"
#include "FQuaternion.h"

class Game;
class Vehicle;

class Area {
public:
	enum areaTypes_e{
		AREA_TYPE_SPAWN = 0,
		AREA_TYPE_CONQUEST,
		AREA_TYPE_REGENERATION,
		AREA_TYPE_TELEPORTATION,

		NUM_AREAS_TYPES
	};

	FVector3 position;
	FQuaternion orientation;


	Area( areaTypes_e areaType );
	virtual ~Area() = 0;

	virtual Area* clone() const = 0;

	virtual void attach( Game* game ) = 0;
	virtual void detach() = 0;
	virtual bool isAttached() const;

	virtual void fromXmlElement( TiXmlElement* xmlElement ) = 0;
	virtual TiXmlElement toXmlElement() const = 0;
	virtual void calculateChecksum() = 0;

	virtual bool canAffectVehicle( Vehicle* vehicle ) const;
	virtual void affectVehicle( Vehicle* vehicle );

	virtual areaTypes_e getAreaType() const;

	virtual const string& getName() const;

protected:
	Game* game;

	areaTypes_e areaType;
	string name;

	unsigned int checksum;

	FVector3 edgeLengths;
};


#endif // __Area_h__
