#ifndef __Arena_h__
#define __Arena_h__


#include "GameObject.h"
#include "FVectors.h"
#include "FQuaternion.h"
#include "FColor.h"

#include <tinyxml.h>

#include <string>
#include <vector>
using namespace std;

class Geometry;
class Effect;
class Area;
class Game;

class Arena{
public:

	struct info_s{
		string description;
	};

	struct graphicalProperties_s{
		Ogre::SceneTypeMask sceneTypeMask;

		string worldGeometrySource;

		struct shadow_s{
			FColor color;
			Ogre::ShadowTechnique technique;
			float farDistance;
			int textureSize;
		} shadow;

		struct fog_s{
			Ogre::FogMode mode;
			FColor color;
			float expDensity;
			float linearStart;
			float linearEnd;
		} fog;

		// skyTechnique
		struct skyBox_s{
			string material;
			float distance;
			bool drawFirst;
			FQuaternion orientation;
		} skyBox;

		string ambientEffect;
		FColor ambientLight;
		FColor backgroundColor;
	};

	struct physicalProperties_s{
		FVector3 gravity;
		FVector3 wind;
		struct collisionSpace_s {
			int quadTreeLevels;
			FVector3 min;
			FVector3 max;
		} collisionSpace;
	};


	Arena();
	~Arena();

	Arena* clone() const;

	void loadFromFile( const string& arenaFilePath );
	void fromXmlElement( TiXmlElement* xmlElement );
	TiXmlElement toXmlElement() const;

	void attach(Game* game);
	void detach();
	bool isAttached() const;

	void collectAreas( list<Area*>& areas ) const;

	const string& getName() const;
	const string& getDescription() const;
	Game* getGame() const;
	void calculateChecksum();
	unsigned int getChecksum() const;

protected:

	struct objectDescriptor_s{
		GameObject::gameObjectTypes_e type;
		string name;
		string templateName;
		FVector3 position;
		FQuaternion orientation;
	};
	typedef map<string, objectDescriptor_s> objectDescriptorsByName_t;
	struct objects_s{
		objectDescriptorsByName_t objectDescriptorsByName;
	};

	typedef map<string, Area*> areasByName_t;
	struct areas_s{
		areasByName_t areasByName;
	};

	string name;

	info_s info;
	graphicalProperties_s graphicalProperties;
	physicalProperties_s physicalProperties;
	objects_s objects;
	areas_s areas;


	unsigned int checksum;
	Game* game;


	void parseArena(TiXmlElement* arenaElement);

	void parseInfo(TiXmlElement* infoElement);
	void parseDescription(TiXmlElement* descriptionElement);

	void parseGraphicalProperties(TiXmlElement* graphicalPropertiesElement);
	void parseShadow(TiXmlElement* shadowElement);
	void parseFog(TiXmlElement* fogElement);
	void parseSkyBox(TiXmlElement* skyBoxElement);
	void parseSkyDome(TiXmlElement* skyDomeElement);
	void parseSkyPlane(TiXmlElement* skyPlaneElement);

	void parsePhysicalProperties(TiXmlElement* physicalPropertiesElement);
	void parseCollisionSpace(TiXmlElement* collisionSpaceElement);

	void parseObjects(TiXmlElement* objectsElement);
	void parseAreas(TiXmlElement* areasElement);
};

#endif // __Arena_h__
