#ifndef __BallisticShot_h__
#define __BallisticShot_h__

#include "Shot.h"

class BallisticShot: public Shot {

friend class BallisticWeapon;

public:
	BallisticShot();
	virtual ~BallisticShot();

	virtual Shot* clone();

	virtual void attach( Game* game );
	virtual void detach();
	virtual void update( float deltaT );

	virtual void prepareForSimulationStep();
	virtual void updateAfterSimulationStep();
	virtual bool collidedWithGameObject( const FVector3& contactPoint, GameObject* other, dContact& contact );
	virtual bool collidedWithTerrain( const FVector3& contactPoint, dContact& contact );

protected:

	dBodyID body;
};

#endif // __BallisticShot_h__
