#ifndef __Camera_h__
#define __Camera_h__

#include "GameObject.h"

#include <Ogre.h>

#include "Input.h"

class Camera: public GameObject{
public:

	enum modes_e{
		MODE_FIRST_PERSON=0,
		MODE_CHASE,
		MODE_THIRD_PERSON,
		MODE_FREE,

		NUM_MODES
	};

	Camera();
	~Camera();

	void processInput(Input::actionMap_t& actionMap, Input::mouseState_t& mouseState);

	void turn(float deltaT);
	void move(float deltaT);
	void update(float deltaT);

	void updateOgreCamera();

	void reset();
	void attach(Game* game);
	void detach();
	bool isAttached() const;

	void targetNextVehicle();
	void targetPreviousVehicle();

	Ogre::Camera* getOgreCamera() const;
	void setOgreCamera(Ogre::Camera* newOgreCamera);
	modes_e getMode() const;
	void setMode(modes_e newMode);
	int* getModePtr() const;

	void lookAt( const FVector3& point );

	void setTarget(GameObject* newTarget);
	GameObject* getTarget() const;

protected:
	modes_e mode;
	Ogre::Camera* ogreCamera;
	GameObject* target;
	float zoom;
};


#endif // __Camera_h__
