#ifndef __Client_h__
#define __Client_h__

#include "Packets.h"

#include "FVectors.h"
#include "FQuaternion.h"

#include <string>
using namespace std;

class Network;
class Socket;
class Server;
class Vehicle;

class Client{

friend class Server;
friend class Network;

public:
	static const int DEFAULT_PORT;
	static const int DEFAULT_CLIENT_STATE_INTERVAL;

	struct properties_s { // things that don't change during a game
		int clientId;
		string name;
		string host;
		int port;
//		int clientStateInterval;
		bool remote;

		Packet::ipAddress_t ipAddress;
	} properties;

	struct info_s { // things that change seldomly during a game
		int ping;
		int secondsOnServer;
		int kills;
		int deaths;
		int score;
		int damageInflicted;
		int team;
		int vehicle;
		int weapons[4];
	} info;

	struct state_s { // things that change often during a game
		int health;
		int energy;

		FVector3 position;
		FQuaternion orientation;
		FVector3 velocity;
		FVector3 angularVelocity;

		unsigned char vehicleSpecificBytes[16];
	} state;

	Client( Network* network );
	~Client();

	void setUp();
	void tearDown();
	void update();


	void establishLoopbackConnection( Server* server );
	void establishRemoteConnection( Server* server );
	void disconnect();

	bool isConnected() const;
	bool isConnectionInterrupted() const;
	Vehicle* getVehicle() const;

	void sendKillPacket( int killedClientId, int killerClientId );
	void sendChatMessagePacket( const string& message, ChatMessagePacket::modes_e mode = ChatMessagePacket::MODE_ALL );
	void sendFirePacket( int weaponSlot, const FVector3& position, const FQuaternion& orientation );

protected:
	Network* network;

	Socket* socket;
	Server* server;
	Vehicle* vehicle;

	unsigned long lastDeathMillis;
	unsigned long lastClientStateMillis;
	unsigned long clientStateIntervalMillis;
	unsigned long lastPingMillis;

	bool ready;
	bool connectionInterrupted;

//	int packetsReceived; // for statistics
//	int packetsSent;

	void resetInfo();
	void resetState();

	void receivePackets();
	void handleConnectPacket( ConnectPacket* cp );
	void handleDisconnectPacket( DisconnectPacket* dp );
	void handlePingPacket( PingPacket* pp );
	void handleSpawnPacket( SpawnPacket* sp );
	void handleKillPacket( KillPacket* kp );
	void handleFirePacket( FirePacket* fp );
	void handleChatMessagePacket( ChatMessagePacket* cmp );
	void handleServerInfoPacket( ServerInfoPacket* sip );
	void handleClientStatePacket( ClientStatePacket* csp );

	void sendPackets();
	void sendSpawnPacket();
	void sendClientStatePacket();
};

#endif // __Client_h__
