#ifndef __ConquestArea_h__
#define __ConquestArea_h__

#include "Area.h"

class Vehicle;

class ConquestArea: public Area {
public:
	static const unsigned long CAPTURE_INTERVAL;

	enum captureStates_e {
		CAPTURE_STATE_NEUTRAL = 0,
		CAPTURE_STATE_RED_UP,
		CAPTURE_STATE_BLUE_UP,
		CAPTURE_STATE_RED,
		CAPTURE_STATE_BLUE,
	};

	ConquestArea();
	virtual ~ConquestArea();

	virtual Area* clone() const;

	virtual void fromXmlElement( TiXmlElement* xmlElement );
	virtual TiXmlElement toXmlElement() const;
	virtual void calculateChecksum();

	virtual void attach( Game* game );
	virtual void detach();

	virtual bool canAffectVehicle( Vehicle* vehicle ) const;
	virtual void affectVehicle( Vehicle* vehicle );

	virtual float getCapturePercentage() const;
	virtual captureStates_e getCaptureState() const;

protected:
	unsigned int teamFlags;

	float capturePercentage;
	captureStates_e captureState;

	Ogre::SceneNode* sceneNode;
	Ogre::ParticleSystem* particleSystem;

};

#endif // __RegenerationArea_h__
