#include "Console.h"

#include "System.h"
#include "ConsoleBackEnd.h"
#include "ConsoleFrontEnd.h"

Console::Console(System* system): SubSystem(system){
	backEnd = new ConsoleBackEnd(this);
	frontEnd = new ConsoleFrontEnd(this);
}

Console::~Console(){
	if( backEnd != NULL )
		delete backEnd;

	if( frontEnd != NULL )
		delete frontEnd;
}

void Console::initialize(){
	System::log("");
	System::log("*** Initializing Console ***");
	System::log("");

	this->initialized = true;
	System::log("Console is ready.");
	System::log("");

}

void Console::shutdown(){

	System::log("");
	System::log("=== Shutting down Console ===");
	System::log("");

	this->initialized = false;
	System::log("Console is down.");
	System::log("");

}


void Console::registerCCmds( Console& console ){
	cCmds.registercvar = new CCmdRegisterCVar();
	console.registerCCmd( cCmds.registercvar );

	cCmds.unregistercvar = new CCmdUnregisterCVar();
	console.registerCCmd( cCmds.unregistercvar );

	cCmds.set = new CCmdSet();
	console.registerCCmd( cCmds.set );
	
	cCmds.val = new CCmdVal();
	console.registerCCmd( cCmds.val );

	cCmds.info = new CCmdInfo();
	console.registerCCmd( cCmds.info );

	cCmds.help = new CCmdHelp();
	console.registerCCmd( cCmds.help );

	cCmds.toggle = new CCmdToggle();
	console.registerCCmd( cCmds.toggle );

	cCmds.exec = new CCmdExec();
	console.registerCCmd( cCmds.exec );

	cCmds.cvarlist = new CCmdCVarList();
	console.registerCCmd( cCmds.cvarlist );

	cCmds.ccmdlist = new CCmdCCmdList();
	console.registerCCmd( cCmds.ccmdlist );

	cCmds.echo = new CCmdEcho();
	console.registerCCmd( cCmds.echo );

}
void Console::unregisterCCmds( Console& console ){
	console.unregisterCCmd( cCmds.registercvar );
	delete cCmds.registercvar;

	console.unregisterCCmd( cCmds.unregistercvar );
	delete cCmds.unregistercvar;

	console.unregisterCCmd( cCmds.set );
	delete cCmds.set;

	console.unregisterCCmd( cCmds.val );
	delete cCmds.val;

	console.unregisterCCmd( cCmds.info );
	delete cCmds.info;

	console.unregisterCCmd( cCmds.help );
	delete cCmds.help;

	console.unregisterCCmd( cCmds.toggle );
	delete cCmds.toggle;

	console.unregisterCCmd( cCmds.exec );
	delete cCmds.exec;

	console.unregisterCCmd( cCmds.cvarlist );
	delete cCmds.cvarlist;

	console.unregisterCCmd( cCmds.ccmdlist );
	delete cCmds.ccmdlist;

	console.unregisterCCmd( cCmds.echo );
	delete cCmds.echo;
}
void Console::registerCVars( Console& console ){
}
void Console::unregisterCVars( Console& console ){
}

//void Console::queuePrintString( const string& printString ){
//	frontEnd->queuePrintString( printString );
//}
void Console::queuePrintString( const string& printString, const FColor& color ){
	frontEnd->queuePrintString( printString, color );
}
void Console::queueInputString( const string& inputString ){
	frontEnd->queueInputString( inputString );
}
void Console::processQueues(){
//	frontEnd->processParseStrings();
	frontEnd->processInputStrings();
	frontEnd->processPrintStrings();
}


void Console::parse( const string& parseString ){
	backEnd->parse( parseString );
}

void Console::registerCVar(CVar* cVar){
	backEnd->registerCVar( cVar );
}

void Console::unregisterCVar(CVar* cVar){
	backEnd->unregisterCVar( cVar );
}

CVar* Console::getCVar(const string& name) const {
	return backEnd->getCVar( name );
}

void Console::writeCVarSettingsToFile( File& file ) const {
	vector<CVar*> cVars;
	this->backEnd->collectRegisteredCVars( cVars );
	for( vector<CVar*>::const_iterator c_iter = cVars.begin(); c_iter != cVars.end(); c_iter++ ){
		if( ((*c_iter)->getFlags() & CVar::FLAG_SYSTEM) != 0 ){
			file.writeLine("set " + (*c_iter)->getName() + " \"" + (*c_iter)->getValueString() + "\"");
		}
	}
}

void Console::registerCCmd(CCmd* cCmd){
	backEnd->registerCCmd( cCmd );
}

void Console::unregisterCCmd(CCmd* cCmd){
	backEnd->unregisterCCmd( cCmd );
}

CCmd* Console::getCCmd(const string& name) const {
	return backEnd->getCCmd( name );
}

