#include "ConsoleMenu.h"

#include "System.h"
#include "Gui.h"
#include "Game.h"
#include "Console.h"
#include "Network.h"
#include "Client.h"

ConsoleMenu::ConsoleMenu(Gui* gui): Menu(gui, "console_menu.layout.xml"){
	this->listbox = static_cast<CEGUI::Listbox*>(
		CEGUI::WindowManager::getSingleton().getWindow( (CEGUI::utf8*)"GuiSheet/ConsoleMenuWindow/Listbox") );
//	listbox->disable();

	this->editbox = (CEGUI::Editbox*)(
		CEGUI::WindowManager::getSingleton().getWindow( (CEGUI::utf8*)"GuiSheet/ConsoleMenuWindow/Editbox")
		);
	editbox->setFont( CEGUI::FontManager::getSingleton().getFont((CEGUI::utf8*)"FixedMediumFont") );
}

ConsoleMenu::~ConsoleMenu(){
}

void ConsoleMenu::show(){
	//this->ceguiWindow->show();
	Menu::show();
	editbox->activate();
}
void ConsoleMenu::hide(){
	//this->ceguiWindow->show();
	editbox->deactivate();
	Menu::hide();
}

void ConsoleMenu::registerEventHandlers(){
//	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();

	CEGUI::FrameWindow* fm = (CEGUI::FrameWindow*)(
			CEGUI::WindowManager::getSingleton().getWindow( (CEGUI::utf8*)"GuiSheet/ConsoleMenuWindow")
		);
	fm->subscribeEvent(
			CEGUI::FrameWindow::EventCloseClicked,
			CEGUI::Event::Subscriber( &ConsoleMenu::handleCloseClicked, this )
		);
	editbox->subscribeEvent(
			CEGUI::Editbox::EventTextAccepted,
			CEGUI::Event::Subscriber( &ConsoleMenu::handleEditboxTextAccepted, this )
		);
	listbox->subscribeEvent(
			CEGUI::Listbox::EventSelectionChanged,
			CEGUI::Event::Subscriber( &ConsoleMenu::handleListboxSelectionChanged, this )
		);

}

void ConsoleMenu::printLine( const string& line ){

	CEGUI::ListboxTextItem *listboxItem = new SingleColumnListboxItem( (CEGUI::utf8*)line.c_str() );
//	listboxItem->setSelectionBrushImage("TaharezLook", "ListboxSelectionBrush");
	listboxItem->setSelected( false );
	listboxItem->setFont( CEGUI::FontManager::getSingleton().getFont( (CEGUI::utf8*)"FixedMediumFont") );

	listbox->addItem( listboxItem );
	listbox->ensureItemIsVisible( listboxItem );

}

void ConsoleMenu::printLine(const string& line, const FColor& color){
	CEGUI::ListboxTextItem *listboxItem = new SingleColumnListboxItem( (CEGUI::utf8*)line.c_str() );
//	listboxItem->setSelectionBrushImage("TaharezLook", "ListboxSelectionBrush");
	listboxItem->setSelected( false );
	listboxItem->setFont( CEGUI::FontManager::getSingleton().getFont( (CEGUI::utf8*)"FixedMediumFont") );

	listboxItem->setTextColours( color.toCeguiColour() );

	listbox->addItem( listboxItem );
	listbox->ensureItemIsVisible( listboxItem );

}

bool ConsoleMenu::handleEditboxTextAccepted(const CEGUI::EventArgs& e){

//	this->printLine( editbox->getText().c_str() );
	string text = string( editbox->getText().c_str() );

	if( text.length() > 0 ){
		if( this->gui->getSystem()->getGame()->isRunning() ){
			if( text[0] == '/' ){ // command
				this->gui->getSystem()->getConsole()->queueInputString( text.substr(1, string::npos) );
			}else{ // chat message
				this->gui->getSystem()->getNetwork()->getClient()->sendChatMessagePacket( text );
			}
		}else{
			this->gui->getSystem()->getConsole()->queueInputString( text );
		}
	}

	this->editbox->setText("");

	return true;
}
bool ConsoleMenu::handleListboxSelectionChanged(const CEGUI::EventArgs& e){

	editbox->setText( listbox->getFirstSelectedItem()->getText() );

	return true;
}
bool ConsoleMenu::handleCloseClicked(const CEGUI::EventArgs& e){
	this->hide();

	return true;
}
