#include "DebugMenu.h"

#include "System.h"
#include "StringConverter.h"

#include "Graphics.h"
#include "Network.h"
#include "Game.h"
#include "Gui.h"

DebugMenu::DebugMenu(Gui* gui): Menu(gui, "debug_menu.layout.xml") {

	this->activePanel = PANEL_OVERVIEW;
}

DebugMenu::~DebugMenu(){
}


void DebugMenu::registerEventHandlers(){
}

void DebugMenu::togglePanel(){
	this->activePanel = (panels_e)( ( this->activePanel + 1 ) % DebugMenu::NUM_PANELS );
}

void DebugMenu::update(){
	switch( this->activePanel ){
		case DebugMenu::PANEL_OVERVIEW:
			updateOverviewPanel();
			break;

		case DebugMenu::PANEL_GRAPHICS:
			updateGraphicsPanel();
			break;
		
		case DebugMenu::PANEL_GAME:
			updateGamePanel();
			break;

		case DebugMenu::PANEL_NETWORK:
			updateNetworkPanel();
			break;

		default: break;
	}
}



void DebugMenu::updateOverviewPanel(){

	const Graphics::stats_s& graphicsStats = this->gui->getSystem()->getGraphics()->getStats();
	const Network::stats_s& networkStats = this->gui->getSystem()->getNetwork()->getStats();
	const Game::stats_s& gameStats = this->gui->getSystem()->getGame()->getStats();

	CEGUI::String currFPS = "CurrentFPS: " + Ogre::StringConverter::toString( graphicsStats.lastFPS );
	CEGUI::String currPing = "CurrentPing: " + Ogre::StringConverter::toString( networkStats.lastPing );
	CEGUI::String pos = "Pos: " + StringConverter::toString( (int)gameStats.position.x )
		+ "," + StringConverter::toString( (int)gameStats.position.y )
		+ "," + StringConverter::toString( (int)gameStats.position.z );

	try{
		CEGUI::Window* heading = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Heading");
		CEGUI::Window* entry1 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry1");
		CEGUI::Window* entry2 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry2");
		CEGUI::Window* entry3 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry3");
		CEGUI::Window* entry4 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry4");
		CEGUI::Window* entry5 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry5");
		CEGUI::Window* entry6 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry6");
		CEGUI::Window* entry7 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry7");
		CEGUI::Window* entry8 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry8");

		heading->setText( "--- OVERVIEW ---" );
		entry1->setText( currFPS );
		entry2->setText( currPing );
		entry3->setText( pos );
		entry4->setText( "" );
		entry5->setText( "" );
		entry6->setText( "" );
		entry7->setText( "" );
		entry8->setText( "" );

	}catch(CEGUI::UnknownObjectException& e){
		// just skip if windows are missing
		e.getMessage();
	}

}

void DebugMenu::updateGraphicsPanel(){
	const Graphics::stats_s& graphicsStats = this->gui->getSystem()->getGraphics()->getStats();

	CEGUI::String currFPS = "CurrentFPS: " + Ogre::StringConverter::toString( graphicsStats.lastFPS );
	CEGUI::String avgFPS = "AverageFPS: " + Ogre::StringConverter::toString( graphicsStats.averageFPS );
	CEGUI::String bestFPS = "BestFPS: " + Ogre::StringConverter::toString( graphicsStats.bestFPS );
	CEGUI::String worstFPS = "WorstFPS: " + Ogre::StringConverter::toString( graphicsStats.worstFPS );
	CEGUI::String tris = "TrisCount: " + Ogre::StringConverter::toString( graphicsStats.triangleCount );

	try{
		CEGUI::Window* heading = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Heading");
		CEGUI::Window* entry1 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry1");
		CEGUI::Window* entry2 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry2");
		CEGUI::Window* entry3 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry3");
		CEGUI::Window* entry4 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry4");
		CEGUI::Window* entry5 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry5");
		CEGUI::Window* entry6 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry6");
		CEGUI::Window* entry7 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry7");
		CEGUI::Window* entry8 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry8");

		heading->setText( "--- GRAPHICS ---" );
		entry1->setText(currFPS);
		entry2->setText(avgFPS);
		entry3->setText(bestFPS);
		entry4->setText(worstFPS);
		entry5->setText(tris);
		entry6->setText( "" );
		entry7->setText( "" );
		entry8->setText( "" );

	}catch(CEGUI::UnknownObjectException& e){
		// just skip if windows are missing
		e.getMessage();
	}

}
void DebugMenu::updateGamePanel(){
	const Game::stats_s& gameStats = this->gui->getSystem()->getGame()->getStats();

	CEGUI::String pos = "Pos: " + StringConverter::toString( gameStats.position );

	try{
		CEGUI::Window* heading = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Heading");
		CEGUI::Window* entry1 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry1");
		CEGUI::Window* entry2 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry2");
		CEGUI::Window* entry3 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry3");
		CEGUI::Window* entry4 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry4");
		CEGUI::Window* entry5 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry5");
		CEGUI::Window* entry6 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry6");
		CEGUI::Window* entry7 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry7");
		CEGUI::Window* entry8 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry8");

		heading->setText( "--- GAME ---" );
		entry1->setText(pos);
		entry2->setText( "" );
		entry3->setText( "" );
		entry4->setText( "" );
		entry5->setText( "" );
		entry6->setText( "" );
		entry7->setText( "" );
		entry8->setText( "" );

	}catch(CEGUI::UnknownObjectException& e){
		// just skip if windows are missing
		e.getMessage();
	}


}
void DebugMenu::updateNetworkPanel(){

	const Network::stats_s& networkStats = this->gui->getSystem()->getNetwork()->getStats();

	CEGUI::String currPing = "CurrentPing: " + Ogre::StringConverter::toString( networkStats.lastPing );
	CEGUI::String bestPing = "BestPing: " + Ogre::StringConverter::toString( networkStats.bestPing );
	CEGUI::String worstPing = "WorstPing: " + Ogre::StringConverter::toString( networkStats.worstPing );
	CEGUI::String traffic = "Traffic: " + Ogre::StringConverter::toString( networkStats.traffic );
	CEGUI::String incoming = "Incoming: " + Ogre::StringConverter::toString( networkStats.incomingTraffic );
	CEGUI::String outgoing = "Outgoing: " + Ogre::StringConverter::toString( networkStats.outgoingTraffic );
	CEGUI::String stateInterval = "StateInt: " + Ogre::StringConverter::toString( networkStats.stateInterval );

	try{
		CEGUI::Window* heading = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Heading");
		CEGUI::Window* entry1 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry1");
		CEGUI::Window* entry2 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry2");
		CEGUI::Window* entry3 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry3");
		CEGUI::Window* entry4 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry4");
		CEGUI::Window* entry5 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry5");
		CEGUI::Window* entry6 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry6");
		CEGUI::Window* entry7 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry7");
		CEGUI::Window* entry8 = CEGUI::WindowManager::getSingleton().getWindow("GuiSheet/DebugMenuWindow/TextPanel/Entry8");

		heading->setText( "--- NETWORK ---" );
		entry1->setText(currPing);
		entry2->setText(bestPing);
		entry3->setText(worstPing);
		entry4->setText(traffic);
		entry5->setText(incoming);
		entry6->setText(outgoing);
		entry7->setText(stateInterval);
		entry8->setText( "" );

	}catch(CEGUI::UnknownObjectException& e){
		// just skip if windows are missing
		e.getMessage();
	}

}

