#ifndef __Effect_h__
#define __Effect_h__

#include <tinyxml.h>
#include <Ogre.h>

#include <string>
#include <list>
using namespace std;

#include "GameObject.h"
#include "FColor.h"

class Effect: public GameObject{
public:
	Effect();
	~Effect();

	virtual Effect* clone() const;

	virtual void loadFromFile( const string& effectFilePath );
	virtual void fromXmlElement( TiXmlElement* xmlElement );
	virtual TiXmlElement toXmlElement() const;

	virtual void attach(Game* game, GameObject* gameObject);
	virtual void attach(Game* game, Ogre::SceneNode* sceneNode);
	virtual void detach();

	virtual void update(float deltaT);

	bool shouldBeDestroyed() const;
	const string& getName() const;
	float getDuration() const;
	GameObject* getGameObject() const;

protected:

	string name;
	unsigned int instanceId;
	string instanceName;
	float duration;
	bool livesForever;
	GameObject* gameObject;

	Ogre::SceneNode* sceneNode;
	list<Ogre::ParticleSystem*> particleSystems;
	list<Ogre::AnimationState*> animationStates;
	list<Ogre::Light*>lights;

	struct mesh_s{
		string fileName;
		bool animated;
	};
	struct particleSystem_s{
		string templateName;
	};
	struct light_s{
		Ogre::Light::LightTypes lightType;
		bool castShadows;
		bool attachToSceneNode;

		FVector3 direction;
		FColor diffuseColor;
		FColor specularColor;
		float attenuationRange;
		float attenuationConstant;
		float attenuationLinear;
		float attenuationQuadratic;

		float spotlightInnerAngle;
		float spotlightOuterAngle;
		float spotlightFalloff;
	};
	struct graphicalProperties_s{
		list<mesh_s> meshes;
		list<particleSystem_s> particleSystems;
		list<light_s> lights;
	} graphicalProperties;

	struct sample_s{
		string fileName;
		int numLoops;
		float volume;
	};
	struct acousticalProperties_s{
		list<sample_s> samples;
	} acousticalProperties;

	virtual void attachStuff( Game* game );

	virtual void parseGraphicalProperties( TiXmlElement* graphicalPropertiesElement );
	virtual void parseMesh( TiXmlElement* meshElement );
	virtual void parseParticleSystem( TiXmlElement* particleSystemElement );
	virtual void parseLight( TiXmlElement* lightSystemElement );

	virtual void parseAcousticalProperties( TiXmlElement* acousticalPropertiesElement );
	virtual void parseSample( TiXmlElement* sampleElement );
};

#endif // __Effect_h__
