#ifndef __Exception_h__
#define __Exception_h__

#include <string>
#include <vector>
#include <iostream>

#include <OgreException.h>
#include <CEGUIExceptions.h>

using namespace std;

class Exception{
public:
	Exception(const string& description, const string& source);
	Exception(const std::exception& e);
	Exception(const Ogre::Exception& e);
	Exception(const CEGUI::Exception& e);
	~Exception();

	const string& getDescription() const;
	const string& getSource() const;
	const vector<string>& getStackTrace() const;
	string getFullInfo() const;
	void printFullInfo( ostream& os ) const;

	void pushStackTraceItem( const string& stackTraceItem );
	string popStackTraceItem();

protected:
	string description;
	string source;
	vector<string> stackTrace;
};

#endif // __Exception_h__
