#include "File.h"

#include "main.h"	// to get FWP_PLATFORM

#if (FWP_PLATFORM == FWP_PLATFORM_WIN32)
// blabla
#elif (FWP_PLATFORM == FWP_PLATFORM_LINUX)
#include <dirent.h>
#include <sys/stat.h>
#endif

File::File(){
//	this->stream = fstream();
	this->path = "";
	this->filename = "";
	this->directory = "";
	this->lineNumber = -1;
}

File::File(const string& path){
	this->path = path;
	this->filename = extractFilename(path);
	this->directory = extractDirectory(path);
	this->stream.open( this->path.c_str() );
	this->lineNumber = -1;
}

//File::File(const string& path, fstream::open_mode open_mode){
File::File(const string& path, ios::openmode openMode){
	this->path = path;
	this->filename = extractFilename(path);
	this->directory = extractDirectory(path);
	this->stream.open( this->path.c_str(), openMode );
	this->lineNumber = -1;
}

File::~File(){
	if( this->stream.is_open() ){
		this->stream.close();
	}
}

bool File::isOpen(){
	return this->stream.is_open();
}

void File::close(){
	this->stream.close();
	this->lineNumber = -1;
}

bool File::readLine( string& line, const string& commentChars ){
	char buffer[1024];
//	if( !stream.is_open() ){
//	}
	if( stream.good() ){
		stream.getline( buffer, 1024 );
		line = string( buffer );
		string::size_type firstCommentChar = line.find_first_of(commentChars);
		if( firstCommentChar != string::npos ){
			line = line.substr( 0, firstCommentChar ); 
		}
		if( line.length() > 0 && line[ line.length()-1 ] == '\r' ){
			line = line.substr( 0, line.length()-1 ); 
		}
		this->lineNumber++;
		return true;
	}else{
		line = string( "<ERROR>" );
		return false;
	}
}

bool File::writeLine( const string& line ){
	if( stream.good() ){
		stream << line << endl;
		this->lineNumber++;
		return true;
	}else{
		return false;
	}
}


const string& File::getPath() const {
	return this->path;
}
const string& File::getDirectory() const {
	return this->directory;
}
const string& File::getFilename() const {
	return this->filename;
}
int File::getLineNumber() const {
	return this->lineNumber;
}


bool File::exists( const string& path ){
	ifstream ifs( path.c_str(), ios::in );

	bool ret = ifs.is_open();
	if( ifs.is_open() ){
		ifs.close();
	}

	return ret;
}
string File::extractFilename(const string& path){
	return path;
}
string File::extractDirectory(const string& path){
	return path;
}
string File::appendFileSeparator(const string& preDirectory){
	string ret;
	
	if( preDirectory.length() > 0 && preDirectory[ preDirectory.length()-1 ] == '/' ){
		ret = preDirectory;
	}else{
		ret = preDirectory + "/";
	}
#if FWP_PLATFORM == FWP_PLATFORM_LINUX
	if( ret[0] == '~' ){
		char* homeDir = getenv( "HOME" );
		ret = homeDir + ret.substr( 1, ret.length()-1 );
	}
#endif
	return ret;
}

bool File::directoryExists( const string& directory ){
#if FWP_PLATFORM == FWP_PLATFORM_LINUX
	DIR* dir = opendir( directory.c_str() );
	if( dir == NULL ){
		return false;
	}else{
		closedir( dir );
		return true;
	}
#elif FWP_PLATFORM == FWP_PLATFORM_WIN32
	return true;
#endif
}

bool File::makeDirectory( const string& directory ){
#if FWP_PLATFORM == FWP_PLATFORM_LINUX
	int ret = mkdir( directory.c_str(), S_IRUSR|S_IWUSR|S_IXUSR );
	return (ret == 0);
#elif FWP_PLATFORM == FWP_PLATFORM_WIN32
	return true;
#endif
}

