#ifndef __File_h__
#define __File_h__

#include <fstream>
#include <string>

using namespace std;

class File{
public:
	File();
	File(const string& path);
	File(const string& path, ios::openmode openMode);
	~File();

	fstream& getStream();
	const string& getPath() const;
	const string& getDirectory() const;
	const string& getFilename() const;
	int getLineNumber() const;

	void open();
	void close();
	bool isOpen();

	bool readLine( string& line, const string& commentChars = "" );
	bool writeLine( const string& line );

	static bool exists(const string& path);
	static string extractFilename(const string& path);
	static string extractDirectory(const string& path);
	static string appendFileSeparator(const string& preDirectory);

	static bool directoryExists(const string& directory);
	static bool makeDirectory(const string& directory);
//	static const string getCurrentWorkingDirectory();

protected:
	fstream stream;
	string path;
	string directory;
	string filename;

	int lineNumber;
};

#endif // __File_h__
