#include "GameInfoMenu.h"

#include "System.h"
#include "Gui.h"
#include "Game.h"
#include "Network.h"
#include "Server.h"
#include "Arena.h"

GameInfoMenu::GameInfoMenu(Gui* gui): Menu(gui, "game_info_menu.layout.xml") {
	this->statusMultiLineEditbox = static_cast<CEGUI::MultiLineEditbox*>(
		CEGUI::WindowManager::getSingleton().getWindow( (CEGUI::utf8*)"GuiSheet/GameInfoMenuWindow/StatusMultiLineEditbox")
		);

	this->descriptionMultiLineEditbox = static_cast<CEGUI::MultiLineEditbox*>(
		CEGUI::WindowManager::getSingleton().getWindow( (CEGUI::utf8*)"GuiSheet/GameInfoMenuWindow/DescriptionMultiLineEditbox")
		);
}

GameInfoMenu::~GameInfoMenu(){
}

void GameInfoMenu::show(){
	Game* game = this->gui->getSystem()->getGame();
	if( !game->isRunning() ){
		return;
	}

	Menu::show();

	Network* network = this->gui->getSystem()->getNetwork();

	char playerInfo[256];
	sprintf(playerInfo, "%i/%i players", network->getServer()->info.numClients, network->getServer()->properties.maxClients );
	string statusString = string( "connected to " )
		+ "'" + network->getServer()->properties.name + "'\n\n"
		+ string( "playing arena " )
		+ network->getServer()->properties.arena
		+ string( " in " )
		+ game->getModeName( game->getMode() )
		+ string( " mode with " )
		+ string( playerInfo );

	this->statusMultiLineEditbox->setText( (CEGUI::utf8*)statusString.c_str() );

	this->descriptionMultiLineEditbox->setText( (CEGUI::utf8*)game->getArena()->getDescription().c_str() );
}

void GameInfoMenu::registerEventHandlers(){
	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();

	CEGUI::FrameWindow* fm = (CEGUI::FrameWindow*)(
			wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/GameInfoMenuWindow")
		);
	fm->subscribeEvent(
			CEGUI::FrameWindow::EventCloseClicked,
			CEGUI::Event::Subscriber( &GameInfoMenu::handleCloseClicked, this )
		);

}

bool GameInfoMenu::handleCloseClicked(const CEGUI::EventArgs& e){
	this->hide();

	return true;
}
