#include "GameObject.h"

#include "System.h"
#include "Exception.h"

//#include <stdio.h>
#include <math.h>

GameObject::GameObject(gameObjectTypes_e gameObjectType){
	this->gameObjectType = gameObjectType;
	this->game = NULL;

	this->position = FVector3::ZERO;
	this->direction = - FVector3::UNIT_Z;
	this->up = FVector3::UNIT_Y;
	this->right = FVector3::UNIT_X;
	this->velocity = FVector3::ZERO;
	this->moveSpeed = 0.0f;

	this->angles = FVector3(0.0f, FLOAT_PI * 0.5f, 0.0f);
	this->angularVelocity = FVector3::ZERO;
	this->turnSpeed = 0.0f;
}

GameObject::~GameObject(){
}


void GameObject::attach(Game* game){
	if( this->game != NULL ){
		throw Exception("GameObject is already attached to a game.", "GameObject::attach()");
	}

	this->game = game;
}
void GameObject::detach(){
	if( this->game == NULL ){
		throw Exception("GameObject is not attached to a game.", "GameObject::detach()");
	}

	this->game = NULL;
}
bool GameObject::isAttached() const {
	return ( game != NULL );
}
Game* GameObject::getGame() const {
	return this->game;
}
void GameObject::update( float deltaT ){
}


void GameObject::prepareForSimulationStep(){
}
void GameObject::updateAfterSimulationStep(){
}
bool GameObject::collidedWithGameObject(const FVector3& contactPoint, GameObject* other, dContact& contact){
	return false;
}
bool GameObject::collidedWithTerrain(const FVector3& contactPoint, dContact& contact){
	return false;
}
void GameObject::addLinearImpulse( const FVector3& impulse, const FVector3& position ){
}
void GameObject::addAngularImpulse( const FVector3& impulse ){
}

void GameObject::damage( float amount ){
}
void GameObject::heal( float amount ){
}
void GameObject::explode(){
}






GameObject::gameObjectTypes_e GameObject::getGameObjectType() const {
	return this->gameObjectType;
}
