#ifndef __Gui_h__
#define __Gui_h__


#include "SubSystem.h"
#include "GuiCCmds.h"
#include "CVar.h"

#include <CEGUIBase.h>
#include <OgreCEGUIRenderer.h>

class Hud;
class Menu;
class Console;

class MainMenu;
class OptionsMenu;
class ConsoleMenu;
class StartServerMenu;
class JoinServerMenu;
class DebugMenu;
class MessageBoxMenu;
class HelpMenu;
class EquipmentMenu;
class GameInfoMenu;
class ScoresMenu;
class MessagesMenu;


class Gui: public SubSystem{
public:
	Gui(System* system);
	~Gui();

	void initialize();
	void shutdown();

	void registerCCmds( Console& console );
	void unregisterCCmds( Console& console );

	struct cVars_s{
		CVarBool* gui_hud_drawMarkers;
		CVarBool* gui_hud_drawTeamStatus;
		CVarBool* gui_openEquipmentMenuUponDeath;
	};
	cVars_s cVars;
	void registerCVars( Console& console );
	void unregisterCVars( Console& console );

	void update();

	void setupBackgroundScene();
	void cleanupBackgroundScene();
	void backgroundSceneMainLoop();
	void setShouldBreakBackgroundSceneMainLoop( bool newShouldBreakBackgroundSceneMainLoop );
	bool getShouldBreakBackgroundSceneMainLoop() const;


	void show();
	void hide();
	bool isVisible() const;
	void toggleVisibility();
	void makeToggleChecks();

	void showMouseCursor();
	void hideMouseCursor();
	void toggleMouseCursorVisibility();

	void showLoadingScreen();
	void hideLoadingScreen();

	void onGameCreation();
	void onGameDestruction();

	void sceneManagerHasChanged( Ogre::SceneManager* newSceneManager );

	CEGUI::Renderer* getCeguiRenderer() const;

	Hud* getHud() const;

	DebugMenu* getDebugMenu() const;
	MessageBoxMenu* getMessageBoxMenu() const;
	MainMenu* getMainMenu() const;
	OptionsMenu* getOptionsMenu() const;
	ConsoleMenu* getConsoleMenu() const;
	StartServerMenu* getStartServerMenu() const;
	JoinServerMenu* getJoinServerMenu() const;
	HelpMenu* getHelpMenu() const;
	EquipmentMenu* getEquipmentMenu() const;
	GameInfoMenu* getGameInfoMenu() const;
	ScoresMenu* getScoresMenu() const;
	MessagesMenu* getMessagesMenu() const;

	bool getOpenEquipmentMenuUponDeath() const;
	bool getDrawHudMarkers() const;
	bool getDrawHudTeamStatus() const;

protected:
	typedef pair<Menu*,bool> menuVisibilityReminder_t;
	typedef list<menuVisibilityReminder_t> escToggledMenus_t;
	escToggledMenus_t escToggledMenus;		// only to remember visible menus when gui is deactivated!

	bool visible;

	bool drawHudMarkers;
	bool drawHudTeamStatus;
	bool openEquipmentMenuUponDeath;

	CEGUI::OgreCEGUIRenderer* ceguiRenderer;
	CEGUI::System* ceguiSystem;
	CEGUI::Window* guiSheet;

	Hud* hud;

	MainMenu* mainMenu;
	OptionsMenu* optionsMenu;
	ConsoleMenu* consoleMenu;
	StartServerMenu* startServerMenu;
	JoinServerMenu* joinServerMenu;
	DebugMenu* debugMenu;
	MessageBoxMenu* messageBoxMenu;
	HelpMenu* helpMenu;
	EquipmentMenu* equipmentMenu;
	GameInfoMenu* gameInfoMenu;
	ScoresMenu* scoresMenu;
	MessagesMenu* messagesMenu;

	Ogre::SceneManager* backgroundSceneManager;
	bool backgroundScene_camera_moveRight;
	bool shouldBreakBackgroundSceneMainLoop;
//	Sound::music_t* backgroundScene_backgroundMusic;

	void updateBackgroundScene();

	void initializeCegui();
	void shutdownCegui();

	void createMenus();
	void destroyMenus();

	void createHud();
	void destroyHud();
};

#endif // __Gui_h__
