#include "InputListener.h"

#include "Input.h"
#include "System.h"
#include "Gui.h"
#include "MessagesMenu.h"
#include "GameInfoMenu.h"
#include "EquipmentMenu.h"
#include "DebugMenu.h"
#include "HelpMenu.h"
#include "ConsoleMenu.h"
#include "ScoresMenu.h"

#include <OgreKeyEvent.h>
#include <OgreMouseEvent.h>


InputListener::InputListener(Input* input){
	this->input = input;
}

InputListener::~InputListener(){
}


// KeyListener interface
void  InputListener::keyClicked (Ogre::KeyEvent *e){
//	System::log("KEY CLICKED!");
	int keyCode = e->getKey();
	input->keyMap[keyCode].clicked = true;

	if( keyCode == Input::KC_ESCAPE ){
		if( this->input->getSystem()->getGui()->getMessagesMenu()->isComposePanelVisible() ){
			this->input->getSystem()->getGui()->getMessagesMenu()->hideComposePanel();
		}else{
			this->input->getSystem()->getGui()->toggleVisibility();
		}
	}

	if( keyCode == Input::KC_F1 )
		this->input->getSystem()->getGui()->getHelpMenu()->toggleVisibility();
	if( keyCode == Input::KC_F12 )
		this->input->getSystem()->getGui()->getConsoleMenu()->toggleVisibility();
	if( keyCode == Input::KC_F5 )
		this->input->getSystem()->getGui()->getDebugMenu()->toggleVisibility();
	if( keyCode == Input::KC_F6 )
		this->input->getSystem()->getGui()->getDebugMenu()->togglePanel();
	if( keyCode == Input::KC_PAUSE )
		this->input->getSystem()->quit();
	if( keyCode == Input::KC_F2 )
		this->input->getSystem()->getGui()->getScoresMenu()->toggleVisibility();
	if( keyCode == Input::KC_F3 )
		this->input->getSystem()->getGui()->getGameInfoMenu()->toggleVisibility();
	if( keyCode == Input::KC_F4 )
		this->input->getSystem()->getGui()->getEquipmentMenu()->toggleVisibility();


	e->consume();
}
void InputListener::keyPressed (Ogre::KeyEvent *e){
	int keyCode = e->getKey();

//	System::log("KC: %i; NAME: %s", keyCode, input->keyMap[keyCode].name.c_str() );

	input->keyMap[keyCode].pressed = true;

	if( input->inputMode == Input::INPUT_MODE_GUI ){
		CEGUI::System::getSingleton().injectKeyDown(keyCode);
		CEGUI::System::getSingleton().injectChar(e->getKeyChar());
	}

	e->consume();
}
void InputListener::keyReleased (Ogre::KeyEvent *e){
	int keyCode = e->getKey();

	input->keyMap[keyCode].pressed = false;

	if( input->inputMode == Input::INPUT_MODE_GUI ){
		CEGUI::System::getSingleton().injectKeyUp(keyCode);
	}
	e->consume();
}
void InputListener::keyFocusIn (Ogre::KeyEvent *e){}
void InputListener::keyFocusOut (Ogre::KeyEvent *e){}

// MouseListener interface
void InputListener::mouseClicked (Ogre::MouseEvent *e){
}
void InputListener::mouseEntered (Ogre::MouseEvent *e){}
void InputListener::mouseExited (Ogre::MouseEvent *e){}
void InputListener::mousePressed (Ogre::MouseEvent *e){
//	System::log("Mouse pressed");
	int mouseButtonCode = InputListener::convertOgreButtonToMouseButtonCode(e->getButtonID());
	this->input->mouseState.buttonMap[mouseButtonCode].pressed = true;

	if( input->inputMode == Input::INPUT_MODE_GUI ){
		CEGUI::System::getSingleton().injectMouseButtonDown(
			InputListener::convertOgreButtonToCeguiButton(e->getButtonID()));
	}
	e->consume();
}
void InputListener::mouseReleased(Ogre::MouseEvent *e){
	int mouseButtonCode = InputListener::convertOgreButtonToMouseButtonCode(e->getButtonID());
	input->mouseState.buttonMap[mouseButtonCode].pressed = false;
	input->mouseState.buttonMap[mouseButtonCode].clicked = true;

	if( input->inputMode == Input::INPUT_MODE_GUI ){
		CEGUI::System::getSingleton().injectMouseButtonUp(
			InputListener::convertOgreButtonToCeguiButton(e->getButtonID()));
	}
	e->consume();
}
void InputListener::mouseDragEntered(Ogre::MouseEvent *e){}
void InputListener::mouseDragExited(Ogre::MouseEvent *e){}
void InputListener::mouseDragDropped(Ogre::MouseEvent *e){}

void InputListener::mouseMoved(Ogre::MouseEvent *e){

	if( input->inputMode == Input::INPUT_MODE_GUI ){
		CEGUI::Renderer* ceguiRenderer = this->input->getSystem()->getGui()->getCeguiRenderer();
		CEGUI::System::getSingleton().injectMouseMove(
			e->getRelX() * ceguiRenderer->getWidth(),
			e->getRelY() * ceguiRenderer->getHeight());
	}

	input->mouseState.xRel += e->getRelX();
	input->mouseState.yRel += e->getRelY();

	e->consume();
}
void InputListener::mouseDragged(Ogre::MouseEvent *e){
	mouseMoved(e);
}
void InputListener::mouseDragMoved(Ogre::MouseEvent *e){}

CEGUI::MouseButton InputListener::convertOgreButtonToCeguiButton(int buttonID){
   switch (buttonID)
   {
   case Ogre::MouseEvent::BUTTON0_MASK:
       return CEGUI::LeftButton;
   case Ogre::MouseEvent::BUTTON1_MASK:
       return CEGUI::RightButton;
   case Ogre::MouseEvent::BUTTON2_MASK:
       return CEGUI::MiddleButton;
   case Ogre::MouseEvent::BUTTON3_MASK:
       return CEGUI::X1Button;
   default:
       return CEGUI::LeftButton;
   }
}


int InputListener::convertOgreButtonToMouseButtonCode(int buttonID){
	switch (buttonID){
		case Ogre::MouseEvent::BUTTON0_MASK:
			return Input::MBC_LEFTBUTTON;
		case Ogre::MouseEvent::BUTTON1_MASK:
			return Input::MBC_RIGHTBUTTON;
		case Ogre::MouseEvent::BUTTON2_MASK:
			return Input::MBC_MIDDLEBUTTON;
		case Ogre::MouseEvent::BUTTON3_MASK:
			return Input::MBC_WHEELUP;
		default:
			return Input::MBC_NOBUTTON;
	}
}




















/*
void InputListener::pollEvents(){
	oi_event evts[2];
	evts[0].type = OI_KEYDOWN;
	evts[0].key.keysym.sym = OIK_Q;
	evts[0].key.type = OI_KEYDOWN;
	evts[1].type = OI_KEYUP;
	evts[1].key.keysym.sym = OIK_Q;
	evts[1].key.type = OI_KEYUP;
//	oi_events_add(evts, 2);

	oi_event e;
//	printf("POLL\n");
	while( oi_events_poll(&e) ){
		printf("EVENT: %i\n", e.type);
		switch(e.type){ 
			case OI_KEYDOWN: this->handleKeyDown(e.key); break;
			case OI_KEYUP: this->handleKeyUp(e.key); break;
			case OI_MOUSEMOVE: this->handleMouseMove(e.move); break;
			case OI_MOUSEBUTTONDOWN: this->handleMouseButtonDown(e.button); break;
			case OI_MOUSEBUTTONUP: this->handleMouseButtonUp(e.button); break;
			case OI_QUIT: this->input->getSystem()->quit(); break;
			default: break;
		}
	}
}
void InputListener::handleKeyDown(const oi_keyboard_event& e){
//	System::log("KEY DOWN: %i", e.keysym.scancode);

	int keyCode = e.keysym.sym;

	// check hard-coded keys
	if( keyCode == Input::KC_ESCAPE )
		this->input->getSystem()->getGui()->toggleVisibility();
	if( keyCode == Input::KC_F12 )
		this->input->getSystem()->getGui()->getConsoleMenu()->toggleVisibility();
	if( keyCode == Input::KC_F5 )
		this->input->getSystem()->getGui()->getDebugMenu()->toggleVisibility();
	if( keyCode == Input::KC_F6 )
		this->input->getSystem()->getGui()->getDebugMenu()->togglePanel();
	if( keyCode == Input::KC_PAUSE )
		this->input->getSystem()->quit();
	if( keyCode == Input::KC_F3 )
		this->input->getSystem()->getGui()->getGameInfoMenu()->toggleVisibility();
	if( keyCode == Input::KC_F4 )
		this->input->getSystem()->getGui()->getEquipmentMenu()->toggleVisibility();

	input->keyMap[keyCode].pressed = true;
	
	if( input->inputMode == Input::INPUT_MODE_GUI ){
		CEGUI::System::getSingleton().injectKeyDown( InputListener::convertOiKeysymToCeguiKeycode(e.keysym) );
//		if( (e.keysym.unicode & 0xFF80) == 0 ){
//			CEGUI::System::getSingleton().injectChar(e.keysym.unicode & 0x7F);
//		}
	}
}
void InputListener::handleKeyUp(const oi_keyboard_event& e){
//	System::log("KEY UP: %i", e.keysym.scancode);

	int keyCode = e.keysym.sym;

	input->keyMap[keyCode].clicked = true;
	input->keyMap[keyCode].pressed = false;

	if( input->inputMode == Input::INPUT_MODE_GUI ){
		CEGUI::System::getSingleton().injectKeyUp(keyCode);
	}
}
void InputListener::handleMouseMove(const oi_mousemove_event& e){
//	System::log("MMOTION");

	Ogre::RenderWindow* window = this->input->getSystem()->getGraphics()->getRenderWindow();
	input->mouseState.xRel += e.relx/(float)window->getWidth();
	input->mouseState.yRel += e.rely/(float)window->getHeight();

	if( input->inputMode == Input::INPUT_MODE_GUI ){
		CEGUI::System::getSingleton().injectMousePosition(e.x, e.y);
	}
}
void InputListener::handleMouseButtonDown(const oi_mousebutton_event& e){
//	System::log("MB DOWN: %i", e.button);

	input->mouseState.buttonMap[ InputListener::convertOiButtonToMouseButtonCode(e.button) ].pressed = true;

	if( input->inputMode == Input::INPUT_MODE_GUI ){
		switch( e.button ){
			case OIP_BUTTON_LEFT:
				CEGUI::System::getSingleton().injectMouseButtonDown(CEGUI::LeftButton);
				break;
			case OIP_BUTTON_MIDDLE:
				CEGUI::System::getSingleton().injectMouseButtonDown(CEGUI::MiddleButton);
				break;
			case OIP_BUTTON_RIGHT:
				CEGUI::System::getSingleton().injectMouseButtonDown(CEGUI::RightButton);
				break;
		
			case OIP_WHEEL_DOWN:
				CEGUI::System::getSingleton().injectMouseWheelChange( -1 );
				break;
			case OIP_WHEEL_UP:
				CEGUI::System::getSingleton().injectMouseWheelChange( +1 );
				break;
		}
	}
}
void InputListener::handleMouseButtonUp(const oi_mousebutton_event& e){
//	System::log("MB UP ENTER");

	input->mouseState.buttonMap[ InputListener::convertOiButtonToMouseButtonCode(e.button) ].pressed = false;
	input->mouseState.buttonMap[ InputListener::convertOiButtonToMouseButtonCode(e.button) ].clicked = true;


	if( input->inputMode == Input::INPUT_MODE_GUI ){
		switch( e.button ){
			case OIP_BUTTON_LEFT:
				CEGUI::System::getSingleton().injectMouseButtonUp(CEGUI::LeftButton);
				break;
			case OIP_BUTTON_MIDDLE:
				CEGUI::System::getSingleton().injectMouseButtonUp(CEGUI::MiddleButton);
				break;
			case OIP_BUTTON_RIGHT:
				CEGUI::System::getSingleton().injectMouseButtonUp(CEGUI::RightButton);
				break;
		}
	}
//	System::log("MB UP RETURN");
}



int InputListener::convertOiButtonToMouseButtonCode(int buttonID){
	switch (buttonID){
		case OIP_BUTTON_LEFT:
			return Input::MBC_LEFTBUTTON;
		case OIP_BUTTON_RIGHT:
			return Input::MBC_RIGHTBUTTON;
		case OIP_BUTTON_MIDDLE:
			return Input::MBC_MIDDLEBUTTON;
		case OIP_WHEEL_UP:
			return Input::MBC_WHEELUP;
		case OIP_WHEEL_DOWN:
			return Input::MBC_WHEELDOWN;
		default:
			return Input::MBC_NOBUTTON;
	}
}

int InputListener::convertOiKeysymToCeguiKeycode( const oi_keysym& keysym ){
	if( System::getInstance()->getPlatform() == System::PLATFORM_WIN32 ){
		return keysym.scancode; // should work as long as OI uses directInput
	}else if( System::getInstance()->getPlatform() == System::PLATFORM_LINUX ){
		switch( keysym.sym ){
			case OIK_ESC: return CEGUI::Key::Escape;
			case OIK_1: return CEGUI::Key::One;
			case OIK_2: return CEGUI::Key::Two;
			case OIK_3: return CEGUI::Key::Three;
			case OIK_4: return CEGUI::Key::Four;
			case OIK_5: return CEGUI::Key::Five;
			case OIK_6: return CEGUI::Key::Six;
			case OIK_7: return CEGUI::Key::Seven;
			case OIK_8: return CEGUI::Key::Eight;
			case OIK_9: return CEGUI::Key::Nine;
			case OIK_0: return CEGUI::Key::Zero;
			case OIK_MINUS: return CEGUI::Key::Minus;
			case OIK_EQUALS: return CEGUI::Key::Equals;
			case OIK_BACKSPACE: return CEGUI::Key::Backspace;
			case OIK_Q: return CEGUI::Key::Q;
			case OIK_W: return CEGUI::Key::W;
			case OIK_E: return CEGUI::Key::E;
			case OIK_R: return CEGUI::Key::R;
			case OIK_T: return CEGUI::Key::T;
			case OIK_Y: return CEGUI::Key::Y;
			case OIK_U: return CEGUI::Key::U;
			case OIK_I: return CEGUI::Key::I;
			case OIK_O: return CEGUI::Key::O;
			case OIK_P: return CEGUI::Key::P;
			case OIK_LEFTBRACKET: return CEGUI::Key::LeftBracket;
			case OIK_RIGHTBRACKET: return CEGUI::Key::RightBracket;
			case OIK_RETURN: return CEGUI::Key::Return;
			case OIK_LCTRL: return CEGUI::Key::LeftControl;
			case OIK_a: return CEGUI::Key::A;
			case OIK_s: return CEGUI::Key::S;
			case OIK_d: return CEGUI::Key::D;
			case OIK_f: return CEGUI::Key::F;
			case OIK_g: return CEGUI::Key::G;
			case OIK_h: return CEGUI::Key::H;
			case OIK_j: return CEGUI::Key::J;
			case OIK_k: return CEGUI::Key::K;
			case OIK_l: return CEGUI::Key::L;
			case OIK_SEMICOLON: return CEGUI::Key::Semicolon;
//			case OIK_??: return CEGUI::Key::Apostrophe;
			case OIK_BACKQUOTE: return CEGUI::Key::Grave;
			case OIK_LSHIFT: return CEGUI::Key::LeftShift;
			case OIK_BACKSLASH: return CEGUI::Key::Backslash;
			case OIK_z: return CEGUI::Key::Z;
			case OIK_x: return CEGUI::Key::X;
			case OIK_c: return CEGUI::Key::C;
			case OIK_v: return CEGUI::Key::V;
			case OIK_b: return CEGUI::Key::B;
			case OIK_n: return CEGUI::Key::N;
			case OIK_m: return CEGUI::Key::M;
			case OIK_COMMA: return CEGUI::Key::Comma;
			case OIK_PERIOD: return CEGUI::Key::Period;
			case OIK_SLASH: return CEGUI::Key::Slash;
			case OIK_RSHIFT: return CEGUI::Key::RightShift;
			case OIK_ASTERISK: return CEGUI::Key::Multiply;
			case OIK_LALT: return CEGUI::Key::LeftAlt;
			case OIK_SPACE: return CEGUI::Key::Space;
			case OIK_CAPSLOCK: return CEGUI::Key::Capital;
			case OIK_F1: return CEGUI::Key::F1;
			case OIK_F2: return CEGUI::Key::F2;
			case OIK_F3: return CEGUI::Key::F3;
			case OIK_F4: return CEGUI::Key::F4;
			case OIK_F5: return CEGUI::Key::F5;
			case OIK_F6: return CEGUI::Key::F6;
			case OIK_F7: return CEGUI::Key::F7;
			case OIK_F8: return CEGUI::Key::F8;
			case OIK_F9: return CEGUI::Key::F9;
			case OIK_F10: return CEGUI::Key::F10;
			case OIK_NUMLOCK: return CEGUI::Key::NumLock;
			case OIK_SCROLLOCK: return CEGUI::Key::ScrollLock;
			case OIK_KP7: return CEGUI::Key::Numpad7;
			case OIK_KP8: return CEGUI::Key::Numpad8;
			case OIK_KP9: return CEGUI::Key::Numpad9;
			case OIK_KP_MINUS: return CEGUI::Key::Subtract;
			case OIK_KP4: return CEGUI::Key::Numpad4;
			case OIK_KP5: return CEGUI::Key::Numpad5;
			case OIK_KP6: return CEGUI::Key::Numpad6;
			case OIK_KP_PLUS: return CEGUI::Key::F1;
			case OIK_KP1: return CEGUI::Key::Numpad1;
			case OIK_KP2: return CEGUI::Key::Numpad2;
			case OIK_KP3: return CEGUI::Key::Numpad3;
			case OIK_KP0: return CEGUI::Key::Numpad0;
			case OIK_KP_PERIOD: return CEGUI::Key::Decimal;
//			case OIK_??: return CEGUI::Key::OEM_102;
			case OIK_F11: return CEGUI::Key::F11;
			case OIK_F12: return CEGUI::Key::F12;
			case OIK_F13: return CEGUI::Key::F13;
			case OIK_F14: return CEGUI::Key::F14;
			case OIK_F15: return CEGUI::Key::F15;
//			case OIK_??: return CEGUI::Key::Kana;
//			case OIK_??: return CEGUI::Key::ABNT_C1;
//			case OIK_??: return CEGUI::Key::Convert;
//			case OIK_??: return CEGUI::Key::NoConvert;
//			case OIK_??: return CEGUI::Key::Yen;
//			case OIK_??: return CEGUI::Key::ABNT_C2;
			case OIK_KP_EQUALS: return CEGUI::Key::NumpadEquals;
//			case OIK_KP_??: return CEGUI::Key::PrevTrack;
			case OIK_AT: return CEGUI::Key::At;
//			case OIK_KP_??: return CEGUI::Key::Colon;
//			case OIK_KP_??: return CEGUI::Key::Underline;
//			case OIK_KP_??: return CEGUI::Key::Kanji;
//			case OIK_KP_??: return CEGUI::Key::Stop;
//			case OIK_KP_??: return CEGUI::Key::AX;
//			case OIK_KP_??: return CEGUI::Key::Unlabeled;
//			case OIK_KP_??: return CEGUI::Key::NextTrack;
			case OIK_KP_ENTER: return CEGUI::Key::NumpadEnter;
			case OIK_RCTRL: return CEGUI::Key::RightControl;
//			case OIK_??: return CEGUI::Key::Mute;
//			case OIK_??: return CEGUI::Key::Calculator;
//			case OIK_??: return CEGUI::Key::PlayPause;
//			case OIK_??: return CEGUI::Key::MediaStop;
//			case OIK_??: return CEGUI::Key::MediaDown;
//			case OIK_??: return CEGUI::Key::VolumeUp;
//			case OIK_??: return CEGUI::Key::VolumeUp;
//			case OIK_??: return CEGUI::Key::WebHome;
//			case OIK_??: return CEGUI::Key::NumpadComma;
			case OIK_KP_DIVIDE: return CEGUI::Key::Divide;
			case OIK_SYSREQ: return CEGUI::Key::SysRq;
			case OIK_RALT: return CEGUI::Key::RightAlt;
			case OIK_PAUSE: return CEGUI::Key::Pause;
			case OIK_HOME: return CEGUI::Key::Home;
			case OIK_UP: return CEGUI::Key::ArrowUp;
			case OIK_PAGEUP: return CEGUI::Key::PageUp;
			case OIK_LEFT: return CEGUI::Key::ArrowLeft;
			case OIK_RIGHT: return CEGUI::Key::ArrowRight;
			case OIK_END: return CEGUI::Key::End;
			case OIK_DOWN: return CEGUI::Key::ArrowDown;
			case OIK_PAGEDOWN: return CEGUI::Key::PageDown;
			case OIK_INSERT: return CEGUI::Key::Insert;
			case OIK_DELETE: return CEGUI::Key::Delete;
			case OIK_LSUPER: return CEGUI::Key::LeftWindows;
			case OIK_RSUPER: return CEGUI::Key::RightWindow;
			case OIK_MENU: return CEGUI::Key::AppMenu;
			case OIK_POWER: return CEGUI::Key::Power;
//			case OIK_??: return CEGUI::Key::Sleep;
//			case OIK_??: return CEGUI::Key::Wake;
//			case OIK_??: return CEGUI::Key::WebSearch;
//			case OIK_??: return CEGUI::Key::WebFavorites;
//			case OIK_??: return CEGUI::Key::WebRefresh;
//			case OIK_??: return CEGUI::Key::WebStop;
//			case OIK_??: return CEGUI::Key::WebForward;
//			case OIK_??: return CEGUI::Key::WebBack;
//			case OIK_??: return CEGUI::Key::MyComputer;
//			case OIK_??: return CEGUI::Key::Mail;
//			case OIK_??: return CEGUI::Key::MediaSelect;

			default: return 0;
		}
	}else{
		return keysym.scancode;
	}
}

*/
