#ifndef __InputListener_h__
#define __InputListener_h__

//#include <openinput.h>
#include <OgreEventListeners.h>
#include <CEGUIInputEvent.h>
class Input;


class InputListener: public Ogre::KeyListener, public Ogre::MouseListener, public Ogre::MouseMotionListener {
public:
	InputListener(Input* input);
	~InputListener();

	// OLD ogre interface
	// KeyListener interface
	void  keyClicked (Ogre::KeyEvent *e);
	void  keyPressed (Ogre::KeyEvent *e);
	void  keyReleased (Ogre::KeyEvent *e);
	void  keyFocusIn (Ogre::KeyEvent *e);
	void  keyFocusOut (Ogre::KeyEvent *e);

	// MouseListener interface
	void  mouseClicked (Ogre::MouseEvent *e);
	void  mouseEntered (Ogre::MouseEvent *e);
	void  mouseExited (Ogre::MouseEvent *e);
	void  mousePressed (Ogre::MouseEvent *e);
	void  mouseReleased (Ogre::MouseEvent *e);
	void  mouseDragEntered (Ogre::MouseEvent *e);
	void  mouseDragExited (Ogre::MouseEvent *e);
	void  mouseDragDropped (Ogre::MouseEvent *e);

	void  mouseMoved (Ogre::MouseEvent *e);
	void  mouseDragged (Ogre::MouseEvent *e);
	void  mouseDragMoved (Ogre::MouseEvent *e);

	CEGUI::MouseButton convertOgreButtonToCeguiButton(int buttonID);
	int convertOgreButtonToMouseButtonCode(int buttonID);

/*
	// SDL interface
	void pollEvents();
	void handleKeyDown(const SDL_KeyboardEvent& e);
	void handleKeyUp(const SDL_KeyboardEvent& e);
	void handleMouseMotion(const SDL_MouseMotionEvent& e);
	void handleMouseButtonDown(const SDL_MouseButtonEvent& e);
	void handleMouseButtonUp(const SDL_MouseButtonEvent& e);

	static int convertSdlButtonToMouseButtonCode(int buttonID);
	static int convertSdlKeysymtoCeguiKeycode( const SDL_keysym& keysym );
*/
/*
	// OpenInput interface
	void pollEvents();
	void handleKeyDown(const oi_keyboard_event& e);
	void handleKeyUp(const oi_keyboard_event& e);
	void handleMouseMove(const oi_mousemove_event& e);
	void handleMouseButtonDown(const oi_mousebutton_event& e);
	void handleMouseButtonUp(const oi_mousebutton_event& e);

	static int convertOiButtonToMouseButtonCode(int buttonID);
	static int convertOiKeysymToCeguiKeycode( const oi_keysym& keysym );
*/
protected:
	Input* input;

};


#endif // __InputListener_h__
