#ifndef __IntersectionQueries_h__
#define __IntersectionQueries_h__

#include "FVectors.h"

#include <list>
using namespace std;

class Physics;
class GameObject;

class IntersectionQuery{
public:
	
	enum resultEntryTypes_e{
		RESULT_ENTRY_TYPE_NONE = 0x00,

		RESULT_ENTRY_TYPE_GAME_OBJECT = 0x01,
		RESULT_ENTRY_TYPE_WORLD_GEOMETRY = 0x02,
		RESULT_ENTRY_TYPE_ARENA_BOUNDARY = 0x04,

		RESULT_ENTRY_TYPE_ALL = 0x07
	};

	struct resultEntry_s{
		resultEntryTypes_e type;
		dGeomID geom;
		GameObject* gameObject;
		FVector3 intersectionPoint;
		FVector3 intersectionNormal;
		float distance;
	};
	typedef list<resultEntry_s> result_t;

	IntersectionQuery( Physics* physics );
	virtual ~IntersectionQuery();

	virtual void execute() = 0;
	
	const result_t& getResult() const;
	void setCollisionFlags(unsigned int flags);
	void setIgnoreGameObject(GameObject* gameObject);

protected:
	Physics* physics;
	unsigned int collisionFlags;
	result_t result;
	GameObject* ignoreGameObject;
};

class RayIntersectionQuery: public IntersectionQuery{
public:
	RayIntersectionQuery( Physics* physics );
	RayIntersectionQuery( Physics* physics, const FVector3& origin, const FVector3& direction, bool sortByDistance = false );
	~RayIntersectionQuery();
	
	virtual void execute();
	static void geomNearGeomCallback(void* data, dGeomID g1, dGeomID g2);

	virtual void setRay( const FVector3& origin, const FVector3& direction, float length = dInfinity );
	virtual void setSortByDistance( bool newSortByDistance );

protected:
	FVector3 origin;
	FVector3 direction;
	float length;

	bool sortByDistance;
};

class SphereIntersectionQuery: public IntersectionQuery{
public:
	SphereIntersectionQuery( Physics* physics );
	SphereIntersectionQuery( Physics* physics, const FVector3& origin, float radius );
	~SphereIntersectionQuery();
	
	virtual void execute();
	static void geomNearGeomCallback(void* data, dGeomID g1, dGeomID g2);

	virtual void setSphere( const FVector3& origin, float radius );
//	virtual void setSortByDistance( bool newSortByDistance );

protected:
	FVector3 origin;
	float radius;

};


#endif // __IntersectionQueries_h__
