#ifndef __JoinServerMenu_h__
#define __JoinServerMenu_h__

#include "Menu.h"

#include "Packets.h"
class Socket;

#include <list>
using namespace std;

class JoinServerMenu: public Menu{
public:
	static const unsigned long MAX_UPDATE_DURATION_MILLIS;

	JoinServerMenu(Gui* gui);
	~JoinServerMenu();

	void show();
	void hide();

	void registerEventHandlers();

	void startUpdate();
	void stopUpdate();
	bool isUpdating() const;
	void update();

	static void messageBoxMenuCallback(void* object);

protected:
	struct serverListEntry_s{
		int id;
		Packet::ipAddress_t ipAddress;
		string host;
		string port;
		string name;
		string arena;
		string mode;
		string currentPlayers;
		string maxPlayers;
		string ping;

		list<string> players;
	};
	typedef list<serverListEntry_s> serverList_t;
	serverList_t serverList;

	CEGUI::MultiColumnList* serverMultiColumnList;
	CEGUI::MultiColumnList* serverInfoMultiColumnList;

	bool updating;
	bool updatingSingleServer;
	unsigned long lastPacketReceivedMillis;
	Packet::ipAddress_t masterServerIpAddress;
	Socket* socket;

	void updateAppearance();

	serverListEntry_s* getServerListEntryById(int id);
	serverListEntry_s* getServerListEntryByIpAddress(const Packet::ipAddress_t& ipAddress);

	void handleMSEntryPacket( MSEntryPacket* ep );
	void handleServerPropertiesPacket( ServerPropertiesPacket* spp );
	void handleServerInfoPacket( ServerInfoPacket* sip );
	void handlePingPacket( PingPacket* pp );

	bool handleCloseClicked(const CEGUI::EventArgs& e);
	bool handleJoinServerButtonClicked(const CEGUI::EventArgs& e);
	bool handleUpdateServerButtonClicked(const CEGUI::EventArgs& e);
	bool handleUpdateServerListButtonClicked(const CEGUI::EventArgs& e);
	bool handleConfigureMasterServerButtonClicked(const CEGUI::EventArgs& e);
	bool handleServerMultiColumnListSelectionChanged(const CEGUI::EventArgs& e);

};


#endif // __JoinServerMenu_h__
