#include "MainMenu.h"

#include "System.h"
#include "Gui.h"
#include "EquipmentMenu.h"
#include "StartServerMenu.h"
#include "JoinServerMenu.h"
#include "OptionsMenu.h"
#include "ConsoleMenu.h"
#include "ScoresMenu.h"
#include "GameInfoMenu.h"

MainMenu::MainMenu(Gui* gui): Menu(gui, "main_menu.layout.xml") {
}

MainMenu::~MainMenu(){
}

void MainMenu::disableGameTab(){
	CEGUI::Window* tmp = CEGUI::WindowManager::getSingleton().getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Game" );
	tmp->disable();
}
void MainMenu::enableGameTab(){
	CEGUI::Window* tmp = CEGUI::WindowManager::getSingleton().getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Game" );
	tmp->enable();
}
void MainMenu::disableEditTab(){
	CEGUI::Window* tmp = CEGUI::WindowManager::getSingleton().getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Edit" );
	tmp->disable();
}
void MainMenu::enableEditTab(){
	CEGUI::Window* tmp = CEGUI::WindowManager::getSingleton().getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Edit" );
	tmp->enable();
}


void MainMenu::registerEventHandlers(){
	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();

	// main tab
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Main/StartServerButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleStartServerButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Main/JoinServerButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleJoinServerButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Main/OptionsButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleOptionsButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Main/ConsoleButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleConsoleButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Main/QuitButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleQuitButtonClicked, this )
		);
/*
	// edit tab
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Options/GraphicsButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleGraphicsButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Options/SoundButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleSoundButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Options/NetworkButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleNetworkButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Options/PlayerButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handlePlayerButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Options/ControlsButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleControlsButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Options/HudButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleHudButtonClicked, this )
		);
*/
	// game tab
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Game/InfoButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleInfoButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Game/ScoresButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleScoresButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Game/VoteButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleVoteButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Game/EquipmentButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleEquipmentButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MainMenuWindow/TabCtrl/Game/DisconnectButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MainMenu::handleDisconnectButtonClicked, this )
		);
}

bool MainMenu::handleStartServerButtonClicked(const CEGUI::EventArgs& e){
	this->gui->getStartServerMenu()->show();
	return true;
}
bool MainMenu::handleJoinServerButtonClicked(const CEGUI::EventArgs& e){
	this->gui->getJoinServerMenu()->show();
	return true;
}
bool MainMenu::handleOptionsButtonClicked(const CEGUI::EventArgs& e){
	this->gui->getOptionsMenu()->show();

	return true;
}
bool MainMenu::handleConsoleButtonClicked(const CEGUI::EventArgs& e){
	this->gui->getConsoleMenu()->show();
	return true;
}
bool MainMenu::handleQuitButtonClicked(const CEGUI::EventArgs& e){
//	System::log("QuitButton clicked");

	this->gui->getSystem()->quit();

	return true;
}

bool MainMenu::handleInfoButtonClicked(const CEGUI::EventArgs& e){
	this->gui->getGameInfoMenu()->show();
	return true;
}
bool MainMenu::handleScoresButtonClicked(const CEGUI::EventArgs& e){
	this->gui->getScoresMenu()->show();
	return true;
}
bool MainMenu::handleVoteButtonClicked(const CEGUI::EventArgs& e){
	return true;
}
bool MainMenu::handleEquipmentButtonClicked(const CEGUI::EventArgs& e){
	this->gui->getEquipmentMenu()->show();
	return true;
}
bool MainMenu::handleDisconnectButtonClicked(const CEGUI::EventArgs& e){
	this->gui->getSystem()->endGame();

	return true;
}
