#include "Menu.h"

#include "System.h"
#include "Gui.h"


Menu::Menu(){
	this->gui = NULL;
	this->ceguiWindow = NULL;
}

Menu::Menu(Gui* gui, const string& layoutPath){
	this->gui = gui;
	this->ceguiWindow = CEGUI::WindowManager::getSingleton().loadWindowLayout( (CEGUI::utf8*)layoutPath.c_str() );
}

Menu::~Menu(){
//	if( this->ceguiWindow != NULL ){
//
//	}
}

void Menu::show(){
	this->ceguiWindow->show();
	this->ceguiWindow->activate();
	this->gui->makeToggleChecks();
}
void Menu::hide(){
	this->ceguiWindow->hide();
	this->gui->makeToggleChecks();
}
bool Menu::isVisible(){
	return this->ceguiWindow->isVisible();
}
void Menu::toggleVisibility(){
	if( this->ceguiWindow->isVisible() ){
		//this->ceguiWindow->hide();
		this->hide();
	}else{
		//this->ceguiWindow->show();
		this->show();
	}
}

