#ifndef __Menu_h__
#define __Menu_h__

#include <OgreNoMemoryMacros.h>

#if defined(_MSC_VER) && (_MSC_VER <= 1200)
#   pragma warning(disable : 4275)
#endif

#include <CEGUI.h>

#if defined(_MSC_VER) && (_MSC_VER <= 1200)
#   pragma warning(default : 4275)
#endif

#include <OgreMemoryMacros.h>

#include <string>

using namespace std;





class SingleColumnListboxItem: public CEGUI::ListboxTextItem{
public:
	SingleColumnListboxItem(const CEGUI::String& text, CEGUI::uint id = 0): ListboxTextItem(text, id){
		setSelectionBrushImage((CEGUI::utf8*)"TaharezLook", (CEGUI::utf8*)"ListboxSelectionBrush");
	}
};
class MultiColumnListboxItem: public CEGUI::ListboxTextItem{
public:
	MultiColumnListboxItem(const CEGUI::String& text, CEGUI::uint id = 0): ListboxTextItem(text, id){
		setSelectionBrushImage((CEGUI::utf8*)"TaharezLook", (CEGUI::utf8*)"MultiListSelectionBrush");
	}
};


class Gui;

class Menu{
public:
	Menu();
	Menu(Gui* gui, const string& layoutPath);
	virtual ~Menu();

	virtual void show();
	virtual void hide();
	virtual bool isVisible();
	virtual void toggleVisibility();

protected:
	Gui* gui;
	CEGUI::Window* ceguiWindow;
};

#endif // __Menu_h__
