#include "MessageBoxMenu.h"

#include "System.h"


MessageBoxMenu::MessageBoxMenu(Gui* gui): Menu(gui, "message_box_menu.layout.xml") {
	this->title = string("Title");
	this->message = string("Message");
	this->buttonText = string("Button");

	this->buttonClickedCallbackFunction = NULL;
	this->buttonClickedCallbackObject = NULL;

	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();

	this->messageMultiLineEditbox = static_cast<CEGUI::MultiLineEditbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MessageBoxMenuWindow/MessageMultiLineEditbox")
		);
	this->button = static_cast<CEGUI::PushButton*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/MessageBoxMenuWindow/Button")
		);

}

MessageBoxMenu::~MessageBoxMenu(){
}

void MessageBoxMenu::show(){
	this->ceguiWindow->setText(this->title);
	this->messageMultiLineEditbox->setText(this->message);
	this->button->setText(this->buttonText);

	Menu::show();
}

void MessageBoxMenu::show(const string& title, const string& message, const string& buttonText){
	this->title = title;
	this->message = message;
	this->buttonText = buttonText;

	this->show();
}

void MessageBoxMenu::hide(){
	this->buttonClickedCallbackFunction = NULL;
	this->buttonClickedCallbackObject = NULL;

	Menu::hide();
}

void MessageBoxMenu::registerEventHandlers(){
	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();

	this->button->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &MessageBoxMenu::handleButtonClicked, this )
		);


}

void MessageBoxMenu::setButtonClickedCallback( void (*function)(void*), void* object ){
	this->buttonClickedCallbackFunction = function;
	this->buttonClickedCallbackObject = object;
}


bool MessageBoxMenu::handleButtonClicked(const CEGUI::EventArgs& e){

	if( this->buttonClickedCallbackFunction != NULL && this->buttonClickedCallbackObject != NULL ){
		this->buttonClickedCallbackFunction(this->buttonClickedCallbackObject);
	}else{
		this->hide();
	}

	return true;
}

