#ifndef __MessagesMenu_h__
#define __MessagesMenu_h__

#include "Menu.h"

#include "FColor.h"
#include "Packets.h"

#include <Ogre.h>

class MessagesMenu: public Menu{
public:

	static const int MAX_MESSAGES;
	static const unsigned long MESSAGE_LIFE_TIME_MILLIS;

	MessagesMenu(Gui* gui);
	~MessagesMenu();

	void show();
	void hide();
	void registerEventHandlers();

	void showComposePanel( ChatMessagePacket::modes_e chatMode );
	void hideComposePanel();
	bool isComposePanelVisible() const;

	void update();

	void addMessage( const string& message, const FColor& color = FColor::WHITE );

protected:
	struct message_s {
		string text;
		FColor color;
		unsigned long addedMillis;
	};

	typedef list< message_s > messages_t;
	messages_t messages;

	CEGUI::StaticText* textPanel;
	CEGUI::StaticText* entries[5];

	CEGUI::StaticText* composePanel;
	CEGUI::StaticText* composeLabel;
	CEGUI::Editbox* composeEditbox;
	ChatMessagePacket::modes_e chatMode;

	void updateAppearance();	
	bool handleComposeEditboxTextAccepted(const CEGUI::EventArgs& e);

};


#endif // __MessagesMenu_h__
