#ifndef __Network_h__
#define __Network_h__

#include "SubSystem.h"
#include "CVar.h"
#include "Packets.h"

class Console;
class Server;
class Client;

class Network: public SubSystem{
public:
	static const int PROTOCOL_VERSION;

	static const int DEFAULT_MASTER_SERVER_PORT;
	static const int DEFAULT_MASTER_SERVER_LOCAL_PORT;

	struct stats_s{
		int lastPing;
		int bestPing;
		int worstPing;
		int stateInterval;
		float traffic;
		float incomingTraffic;
		float outgoingTraffic;

		int incomingBytes;
		int outgoingBytes;
		float secondsSinceLastTrafficUpdate;
	};

	struct masterServerProperties_s{
		string host;
		int port;
		int localPort;
	};


	Network(System* system);
	~Network();

	void initialize();
	void shutdown();

	void registerCCmds( Console& console );
	void unregisterCCmds( Console& console );

	struct cVars_s{
		CVarInt* network_protocolVersion;
//		CVarInt* network_connectionSpeed;

		CVarString* network_server_name;
		CVarString* network_server_host;
		CVarInt* network_server_port;
		CVarInt* network_server_maxClients;
		CVarInt* network_server_connectionSpeed;
		CVarBool* network_server_remote;
		CVarBool* network_server_registerOnMasterServer;
		CVarString* network_server_arena;
		CVarInt* network_server_gameMode;
		CVarInt* network_server_ghostTime;

		CVarInt* network_client_port;
		CVarInt* network_client_team;
		CVarString* network_client_name;
		CVarInt* network_client_vehicle;
		CVarInt* network_client_weapon1;
		CVarInt* network_client_weapon2;
		CVarInt* network_client_weapon3;
		CVarInt* network_client_weapon4;

		CVarString* network_masterServer_host;
		CVarInt* network_masterServer_port;
		CVarInt* network_masterServer_localPort;
	};
	cVars_s cVars;
	void registerCVars( Console& console );
	void unregisterCVars( Console& console );

	void onGameCreation();
	void onGameDestruction();
	void update();

	void notifyPacketSent( Packet* packet );
	void notifyPacketReceived( Packet* packet );

	Server* getServer() const;
	Client* getClient() const;
//	int getConnectionSpeed() const;
	const stats_s& getStats() const;
	const masterServerProperties_s& getMasterServerProperties() const;

	static Packet::ipAddress_t resolveHost( const string& host, int port );
	static string ipAddressToString( const Packet::ipAddress_t ipAddress );

protected:
	masterServerProperties_s masterServerProperties;

	Server* server;
	Client* client;

	stats_s stats;

	void updateStats();
	void resetStats();

};

#endif // __Network_h__
