#include "OptionsMenu.h"

#include "System.h"
#include "Gui.h"
#include "Graphics.h"
#include "Network.h"

OptionsMenu::OptionsMenu(Gui* gui): Menu(gui, "options_menu.layout.xml"){
	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();


	this->enableShadowsCheckbox = static_cast<CEGUI::Checkbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Graphics/EnableShadowsCheckbox" )
		);
	this->forceOgreConfigDialogCheckbox = static_cast<CEGUI::Checkbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Graphics/ForceOgreConfigDialogCheckbox" )
		);

	this->playerNameEditbox = static_cast<CEGUI::Editbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Gameplay/PlayerNameEditbox" )
		);
	this->autoOpenEquipmentMenuCheckbox = static_cast<CEGUI::Checkbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Gameplay/AutoOpenEquipmentMenuCheckbox" )
		);
	this->drawHudMarkersCheckbox = static_cast<CEGUI::Checkbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Gameplay/DrawHudMarkersCheckbox" )
		);
	this->drawHudTeamStatusCheckbox = static_cast<CEGUI::Checkbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Gameplay/DrawHudTeamStatusCheckbox" )
		);

	this->serverPortEditbox = static_cast<CEGUI::Editbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Network/ServerPortEditbox" )
		);
	this->serverConnectionSpeedEditbox = static_cast<CEGUI::Editbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Network/ServerConnectionSpeedEditbox" )
		);
	this->clientPortEditbox = static_cast<CEGUI::Editbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Network/ClientPortEditbox" )
		);
	this->clientConnectionSpeedEditbox = static_cast<CEGUI::Editbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Network/ClientConnectionSpeedEditbox" )
		);
	this->masterServerHostEditbox = static_cast<CEGUI::Editbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Network/MasterServerHostEditbox" )
		);
	this->masterServerPortEditbox = static_cast<CEGUI::Editbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Network/MasterServerPortEditbox" )
		);

}

OptionsMenu::~OptionsMenu(){
}

void OptionsMenu::show(){
	Menu::show();

	// init gui elements
//	int i;
	Game* game = this->gui->getSystem()->getGame();
	Network* network = this->gui->getSystem()->getNetwork();
	Graphics* graphics = this->gui->getSystem()->getGraphics();

	// graphics
	this->enableShadowsCheckbox->setSelected( graphics->cVars.graphics_shadowsEnabled->getValue() );
	this->forceOgreConfigDialogCheckbox->setSelected( graphics->cVars.graphics_forceOgreConfigDialog->getValue() );

	// sound

	// gameplay
	this->playerNameEditbox->setText( network->cVars.network_client_name->getValue() );
//	this->playerNameEditbox->setValidationString((CEGUI::utf8*)"\\a*");
	this->autoOpenEquipmentMenuCheckbox->setSelected( this->gui->cVars.gui_openEquipmentMenuUponDeath->getValue() );
	this->drawHudMarkersCheckbox->setSelected( this->gui->cVars.gui_hud_drawMarkers->getValue() );
	this->drawHudTeamStatusCheckbox->setSelected( this->gui->cVars.gui_hud_drawTeamStatus->getValue() );

	// network
	this->serverPortEditbox->setText( network->cVars.network_server_port->getValueString() );
	this->serverConnectionSpeedEditbox->setText( network->cVars.network_server_connectionSpeed->getValueString() );
	this->clientPortEditbox->setText( network->cVars.network_client_port->getValueString() );
//	this->clientStateIntervalEditbox->setText( network->cVars.network_client_clientStateInterval->getValueString() );
	this->masterServerHostEditbox->setText( network->cVars.network_masterServer_host->getValueString() );
	this->masterServerPortEditbox->setText( network->cVars.network_masterServer_port->getValueString() );


}
void OptionsMenu::registerEventHandlers(){
	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();

	CEGUI::FrameWindow* fm = (CEGUI::FrameWindow*)(
			wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow")
		);
	fm->subscribeEvent(
			CEGUI::FrameWindow::EventCloseClicked,
			CEGUI::Event::Subscriber( &OptionsMenu::handleCloseClicked, this )
		);

	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/ApplyButton" )->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &OptionsMenu::handleApplyButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/OkButton" )->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &OptionsMenu::handleOkButtonClicked, this )
		);
/*
	this->enableShadowsCheckbox->subscribeEvent(
			CEGUI::Checkbox::EventCheckStateChanged,
			CEGUI::Event::Subscriber( &OptionsMenu::handleEnableShadowsCheckboxCheckStateChanged, this )
		);
*/
}

void OptionsMenu::activateNetworkTab(){
	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();
	static_cast<CEGUI::TabControl*> (wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl" ) )
		->setSelectedTab( (CEGUI::utf8*)"GuiSheet/OptionsMenuWindow/TabCtrl/Network" );
}


bool OptionsMenu::handleCloseClicked(const CEGUI::EventArgs& e){
	this->hide();

	return true;
}

bool OptionsMenu::handleApplyButtonClicked(const CEGUI::EventArgs& e){
	this->applySettings();

	return true;
}
bool OptionsMenu::handleOkButtonClicked(const CEGUI::EventArgs& e){
	this->applySettings();
	this->hide();

	return true;
}

void OptionsMenu::applySettings(){
	Graphics* graphics = this->gui->getSystem()->getGraphics();
	Game* game = this->gui->getSystem()->getGame();
	Network* network = this->gui->getSystem()->getNetwork();

	// graphics
	bool val = this->enableShadowsCheckbox->isSelected();
	graphics->cVars.graphics_shadowsEnabled->setValue( val );
	graphics->setShadowsEnabled(val);

	val = this->forceOgreConfigDialogCheckbox->isSelected();
	graphics->cVars.graphics_forceOgreConfigDialog->setValue( val );

	// gameplay
	network->cVars.network_client_name->setValueString( this->playerNameEditbox->getText().c_str() );
	this->gui->cVars.gui_openEquipmentMenuUponDeath->setValue( this->autoOpenEquipmentMenuCheckbox->isSelected() );
	this->gui->cVars.gui_hud_drawMarkers->setValue( this->drawHudMarkersCheckbox->isSelected() );
	this->gui->cVars.gui_hud_drawTeamStatus->setValue( this->drawHudTeamStatusCheckbox->isSelected() );

	// network
	network->cVars.network_server_port->setValueString( this->serverPortEditbox->getText().c_str() );
	network->cVars.network_server_connectionSpeed->setValueString( this->serverConnectionSpeedEditbox->getText().c_str() );

	network->cVars.network_client_port->setValueString( this->clientPortEditbox->getText().c_str() );
//	network->cVars.network_client_clientStateInterval->setValueString( this->clientStateIntervalEditbox->getText().c_str() );

	network->cVars.network_masterServer_host->setValueString( this->masterServerHostEditbox->getText().c_str() );
	network->cVars.network_masterServer_port->setValueString( this->masterServerPortEditbox->getText().c_str() );
}

/*
bool OptionsMenu::handleEnableShadowsCheckboxCheckStateChanged(const CEGUI::EventArgs& e){
	bool val = this->enableShadowsCheckbox->isSelected();

	Graphics* graphics = this->gui->getSystem()->getGraphics();
	graphics->cVars.graphics_shadowsEnabled->setValue( val );
	graphics->setShadowsEnabled(val);

	return true;
}
*/
