#include "ProjectileShot.h"

#include "System.h"
#include "Exception.h"
#include "Game.h"
#include "Effect.h"
#include "EffectFactory.h"
#include "Vehicle.h"
//#include <ode/ode.h>

ProjectileShot::ProjectileShot(): Shot( Shot::SHOT_TYPE_PROJECTILE ) {
	this->ray = 0;
}

ProjectileShot::~ProjectileShot(){
}

Shot* ProjectileShot::clone(){
	ProjectileShot* ret = new ProjectileShot();

	*ret = *this;

	return ret;
}

void ProjectileShot::attach( Game* game ){
	if( this->game != NULL ){
		throw Exception("Shot is already attached to a game.", "Shot::attach()");
	}

	this->id = game->getNextId();

	this->lifeTime = this->physicalProperties.lifeTime;

	// set up velocity
//	this->velocity = 

	// add ray to physics
	this->ray = dCreateRay( game->getPhysics()->getDynamicGeometrySpace(), 0.0f );
	dVector4 o;
	this->orientation.toOdeVector4( o );
	dGeomRaySet( this->ray, this->position.x, this->position.y, this->position.z,
		this->direction.x, this->direction.y, this->direction.z );
	dGeomSetData( this->ray, this );

	// create effect
	if( !this->graphicalProperties.travelEffect.empty() ){
		this->travelEffect = game->getEffectFactory()->createEffect( this->graphicalProperties.travelEffect );
		this->travelEffect->attach( game, this );
	}

	this->game = game;
}
void ProjectileShot::detach(){
	if( this->game == NULL ){
		throw Exception("Shot is not attached to a game.", "Shot::detach()");
	}

	if( this->travelEffect != NULL ){
		this->travelEffect->detach();
		this->game->getEffectFactory()->destroyEffect( this->travelEffect );
	}

	// remove and destroy ray
	dGeomDestroy( this->ray );

	this->game = NULL;


}
void ProjectileShot::update( float deltaT ){

	this->position = this->position + this->velocity * deltaT;

	if( this->travelEffect != NULL ){
		this->travelEffect->update( deltaT );
	}

	this->lifeTime -= deltaT;

	if( this->lifeTime < 0.0f && this->physicalProperties.explosionRadius > 0.0f ){
		this->explode();
	}

}

void ProjectileShot::prepareForSimulationStep(){

	float deltaT = this->game->getSystem()->getTimer()->getDeltaT();

	// update geom
	dGeomRaySet( this->ray, this->position.x, this->position.y, this->position.z,
		this->direction.x, this->direction.y, this->direction.z );
	dGeomRaySetLength( this->ray, this->velocity.length() * deltaT );

//	cout << "length: " << this->velocity.length() * deltaT << endl;

}
void ProjectileShot::updateAfterSimulationStep(){
}

bool ProjectileShot::collidedWithGameObject(const FVector3& contactPoint, GameObject* other, dContact& contact){
//	printf("GO\n");
	
	if( other == NULL || other == this->game->getVehicleByClientId( this->clientId ) ){
		return false;
	}

	// explosion
	this->impact( contactPoint, other );
//	this->explode( other );

	this->lifeTime = -1.0f;

	return false;
}
bool ProjectileShot::collidedWithTerrain(const FVector3& contactPoint, dContact& contact){
//	printf("TE\n");

//	if( this->physicalProperties.explosionRadius > 0.0f ){
	this->position = contactPoint;
	this->explode();
//	}

	this->lifeTime = -1.0f;

	return false;
}

