#ifndef __ProjectileShot_h__
#define __ProjectileShot_h__

#include "Shot.h"

class ProjectileShot: public Shot {

friend class ProjectileWeapon;

public:
	ProjectileShot();
	virtual ~ProjectileShot();

	virtual Shot* clone();

	virtual void attach( Game* game );
	virtual void detach();
	virtual void update( float deltaT );

	virtual void prepareForSimulationStep();
	virtual void updateAfterSimulationStep();
	virtual bool collidedWithGameObject( const FVector3& contactPoint, GameObject* other, dContact& contact );
	virtual bool collidedWithTerrain( const FVector3& contactPoint, dContact& contact );

protected:

	dGeomID ray;
};

#endif // __ProjectileShot_h__
