#ifndef __Shape_h__
#define __Shape_h__

#include "Physics.h"

#include <tinyxml.h>

#include <vector>
using namespace std;

class Shape{
public:

	Shape();
	~Shape();

	void fromXmlElement( TiXmlElement* xmlElement );
	TiXmlElement toXmlElement() const;

	void clear();

	void createGeoms( void* data = NULL );
	void destroyGeoms();
	void attachGeomsToBody( dBodyID body );
	void detachGeomsFromBody();
	void addGeomsToSpace( dSpaceID space );
	void removeGeomsFromSpace( dSpaceID space );

	void setGeomsPosition( const FVector3& pos );
	void setGeomsOrientation( const FQuaternion& ori );
	const vector<dGeomID>& getGeoms() const;

protected:

	struct geomInfo_s{
		int geomClass;
		FVector3 center;
		FVector3 edgeLengths;
		float radius;
		float length;
	};

	vector<geomInfo_s> geomInfos;
	vector<dGeomID> geoms;

	void parseBox(TiXmlElement* boxElement);
	void parseSphere(TiXmlElement* sphereElement);
	void parseCapsule(TiXmlElement* capsuleElement);

};

#endif // __Shape_h__
