#ifndef __Shot_h__
#define __Shot_h__

#include "GameObject.h"
#include "Shape.h"

class Effect;

class Shot: public GameObject {

friend class Weapon;

public:

	enum shotTypes_e {
		SHOT_TYPE_PROJECTILE = 0,
		SHOT_TYPE_BALLISTIC,
		SHOT_TYPE_RAY,

		NUM_SHOT_TYPES
	};

	struct graphicalProperties_s {
		string travelEffect;
		string explosionEffect;
	};

	struct physicalProperties_s {
		float damage;
		float lifeTime;
		float impactImpulse;
		float explosionRadius;
		float muzzleVelocity;
		FVector3 propulsiveForce;
		bool causesThermalShock;

		float bouncyness;
		float friction;
		bool affectedByGravity;
		dMass mass;
		Shape shape;
	};

	struct acousticalProperties_s {
	};

	Shot( shotTypes_e shotType );
	virtual ~Shot() = 0;

	virtual Shot* clone() = 0;

	virtual void fromXmlElement( TiXmlElement* xmlElement );
	virtual TiXmlElement toXmlElement() const;
	virtual void calculateChecksum();

	virtual void attach( Game* game ) = 0;
	virtual void detach() = 0;
	virtual void update( float deltaT ) = 0;

	virtual void prepareForSimulationStep() = 0;
	virtual void updateAfterSimulationStep() = 0;
	virtual bool collidedWithGameObject(const FVector3& contactPoint, GameObject* other, dContact& contact) = 0;
	virtual bool collidedWithTerrain(const FVector3& contactPoint, dContact& contact) = 0;

	virtual void damage( float amount );
	virtual void explode( GameObject* ignoreGameObject = NULL );

	virtual const string& getName() const;
	virtual unsigned int getChecksum() const;
	virtual bool shouldBeDestroyed() const;
	virtual int getClientId() const;
	virtual const physicalProperties_s& getPhysicalProperties() const;
	virtual const graphicalProperties_s& getGraphicalProperties() const;

protected:
	shotTypes_e shotType;
	int clientId;

	string name;
	unsigned int checksum;

	graphicalProperties_s graphicalProperties;
	physicalProperties_s physicalProperties;
	acousticalProperties_s acousticalProperties;

	unsigned int id;
	float lifeTime;
	bool exploded;

	Effect* travelEffect;

	virtual void impact( const FVector3& contactPoint, GameObject* other );

	virtual void parseGraphicalProperties( TiXmlElement* graphicalPropertiesElement );
	virtual void parsePhysicalProperties( TiXmlElement* physicalPropertiesElement );
	virtual void parseAcousticalProperties( TiXmlElement* acousticalPropertiesElement );

	virtual void parseMass( TiXmlElement* massElement );

};

#endif // __Shot_h__
