#ifndef __Sound_h__
#define __Sound_h__

#include "SubSystem.h"
#include "FVectors.h"
#include "CVar.h"

#include <string>
using namespace std;

#include <SDL_mixer.h>

class Console;


class Sound: public SubSystem{
public:
	enum channels_e{
		SOUND_COMPUTER_CHANNEL,
		SOUND_RADIO_CHANNEL,
		SOUND_ANNOUNCER_CHANNEL,

		FIRST_EFFECT_CHANNEL,

		NUM_CHANNELS
	};


	typedef Mix_Chunk sample_t;
//	typedef FMUSIC_MODULE music_t;

	Sound(System* system);
	~Sound();

	void initialize();
	void shutdown();

	void registerCCmds( Console& console );
	void unregisterCCmds( Console& console );

	struct cVars_s{
		CVarBool* sound_enabled;
		CVarInt* sound_numEffectChannels;
	} cVars;
	void registerCVars( Console& console );
	void unregisterCVars( Console& console );

	void update();

	void setListenerAttributes(const FVector3& pos, const FVector3& dir, const FVector3& up, const FVector3& vel);
	sample_t* getSample( const string& name );
	void playSample( int channel, sample_t* sample, int numLoops = 0, int numMillis = -1 );
	void playSample( const FVector3& pos, sample_t* sample, int numLoops = 0, int numMillis = -1 );

	int acquireEffectChannel();


//	music_t* loadMusic( const string& path );
//	void freeMusic( music_t* music );
//	void playMusic( music_t* music );
//	void stopMusic( music_t* music );

	bool isEnabled() const;

protected:
	bool enabled;
	int sampleVolume;
	bool stereo;
	int chunkSize;
	int samplingRate;
	int numEffectChannels;

	int effectChannelsGroup;
	
	struct listener_s{
		FVector3 position;
		FVector3 direction;
		FVector3 up;
		FVector3 velocity;
	} listener;

	typedef map<string, sample_t*> samplesByName_t;
	samplesByName_t samplesByName;



	sample_t* loadSample( const string& path );
	void freeSample( sample_t* sample );
};

#endif // __Sound_h__
