#include "StartServerMenu.h"


#include "System.h"
#include "Gui.h"
#include "Network.h"
#include "Game.h"
#include "ArenaFactory.h"
#include "OptionsMenu.h"

StartServerMenu::StartServerMenu(Gui* gui): Menu(gui, "start_server_menu.layout.xml") {
	this->arenaNames.clear();

	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();

	this->serverNameEditbox = (CEGUI::Editbox*)(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/StartServerMenuWindow/ServerNameEditbox")
		);
	this->gameModeCombobox = static_cast<CEGUI::Combobox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/StartServerMenuWindow/GameModeCombobox")
		);
	this->playerLimitCombobox = static_cast<CEGUI::Combobox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/StartServerMenuWindow/PlayerLimitCombobox")
		);
	this->arenaListbox = static_cast<CEGUI::Listbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/StartServerMenuWindow/ArenaListbox")
		);
	this->descriptionMultiLineEditbox = static_cast<CEGUI::MultiLineEditbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/StartServerMenuWindow/DescriptionMultiLineEditbox")
		);
	this->registerOnMasterServerCheckbox = static_cast<CEGUI::Checkbox*>(
		wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/StartServerMenuWindow/RegisterOnMasterServerCheckbox")
		);

}

StartServerMenu::~StartServerMenu(){
}

void StartServerMenu::show(){
	Menu::show();

	// init gui elements
	int i;
	CEGUI::ListboxTextItem *listboxItem = NULL; // universal pointer for listboxItems
	Game* game = this->gui->getSystem()->getGame();
	Network* network = this->gui->getSystem()->getNetwork();

	// server name
//	string serverName = game->cVars.game_player_name->getValue() + "'s server";
	this->serverNameEditbox->setText( network->cVars.network_server_name->getValue() );

	// game mode
	this->gameModeCombobox->resetList();
	for( i=0; i<Game::NUM_MODES; i++ ){
		listboxItem = new CEGUI::ListboxTextItem( (CEGUI::utf8*)Game::getModeName(i).c_str() );
		this->gameModeCombobox->addItem(listboxItem);
	}
	this->gameModeCombobox->setText( Game::getModeName( network->cVars.network_server_gameMode->getValue() ).c_str() );

	// player limit
	this->playerLimitCombobox->resetList();
	for( i=1; i<=16; i++ ){
		char buff[16];
		sprintf(buff, "%i", i);
		listboxItem = new CEGUI::ListboxTextItem( (CEGUI::utf8*)buff );
		this->playerLimitCombobox->addItem(listboxItem);
	}
	this->playerLimitCombobox->setText( network->cVars.network_server_maxClients->getValueString() );

	// arena
	ArenaFactory* af = this->gui->getSystem()->getGame()->getArenaFactory();
	this->arenaNames.clear();
	this->arenaNames = af->getArenaNames();

	this->arenaListbox->resetList();
	for( vector<string>::const_iterator c_iter = this->arenaNames.begin(); c_iter != this->arenaNames.end(); c_iter++ ){
		listboxItem = new SingleColumnListboxItem( (CEGUI::utf8*)c_iter->c_str() );
//		listboxItem->setSelectionBrushImage("TaharezLook", "ListboxSelectionBrush");
		listboxItem->setSelected( false );

		this->arenaListbox->addItem( listboxItem );

		if( *c_iter == network->cVars.network_server_arena->getValue() ){
			this->arenaListbox->setItemSelectState( listboxItem, true );
		}
	}

	// register on master server
	this->registerOnMasterServerCheckbox->setSelected( network->cVars.network_server_registerOnMasterServer->getValue() );

}

void StartServerMenu::registerEventHandlers(){
	CEGUI::WindowManager& wmgr = CEGUI::WindowManager::getSingleton();

	CEGUI::FrameWindow* fm = (CEGUI::FrameWindow*)(
			wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/StartServerMenuWindow")
		);
	fm->subscribeEvent(
			CEGUI::FrameWindow::EventCloseClicked,
			CEGUI::Event::Subscriber( &StartServerMenu::handleCloseClicked, this )
		);

	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/StartServerMenuWindow/StartServerButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &StartServerMenu::handleStartServerButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/StartServerMenuWindow/ExpertSettingsButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &StartServerMenu::handleExpertSettingsButtonClicked, this )
		);
	wmgr.getWindow( (CEGUI::utf8*)"GuiSheet/StartServerMenuWindow/ConfigureMasterServerButton" )
		->subscribeEvent(
			CEGUI::PushButton::EventClicked,
			CEGUI::Event::Subscriber( &StartServerMenu::handleConfigureMasterServerButtonClicked, this )
		);

	this->arenaListbox->subscribeEvent(
			CEGUI::Listbox::EventSelectionChanged,
			CEGUI::Event::Subscriber( &StartServerMenu::handleArenaListboxSelectionChanged, this )
		);
}

bool StartServerMenu::handleCloseClicked(const CEGUI::EventArgs& e){
	this->hide();

	return true;
}
bool StartServerMenu::handleStartServerButtonClicked(const CEGUI::EventArgs& e){
	// apply settings
	Game* game = this->gui->getSystem()->getGame();
	Network* network = this->gui->getSystem()->getNetwork();

	// server name
	string serverName = string( this->serverNameEditbox->getText().c_str() );
	network->cVars.network_server_name->setValueString( serverName );

	// game mode
	string gameModeString = this->gameModeCombobox->getText().c_str();
	if( gameModeString == string("edit") ){
		network->cVars.network_server_gameMode->setValue( Game::MODE_EDIT );
	}else if( gameModeString == string("deathmatch") ){
		network->cVars.network_server_gameMode->setValue( Game::MODE_DEATHMATCH );
	}else if( gameModeString == string("team deathmatch") ){
		network->cVars.network_server_gameMode->setValue( Game::MODE_TEAM_DEATHMATCH );
	}else if( gameModeString == string("conquest") ){
		network->cVars.network_server_gameMode->setValue( Game::MODE_CONQUEST );
	}else{
		network->cVars.network_server_gameMode->setValue( Game::MODE_DEATHMATCH );
	}

	// maxPlayers
	network->cVars.network_server_maxClients->setValueString( string( this->playerLimitCombobox->getText().c_str() ) );

	// arena
	CEGUI::ListboxItem* lbi = this->arenaListbox->getFirstSelectedItem();
	if( lbi != NULL ){
		network->cVars.network_server_arena->setValue( string(lbi->getText().c_str()) );
	}

	// register on master server
	network->cVars.network_server_registerOnMasterServer->setValue( this->registerOnMasterServerCheckbox->isSelected() );

	// we want a server running on this machine...
	network->cVars.network_server_host->setValue( "localhost" );
	network->cVars.network_server_remote->setValue( false );

	this->hide();

	this->gui->getSystem()->startGame();

	return true;
}
bool StartServerMenu::handleExpertSettingsButtonClicked(const CEGUI::EventArgs& e){
	return true;
}
bool StartServerMenu::handleConfigureMasterServerButtonClicked(const CEGUI::EventArgs& e){
	OptionsMenu* om = this->gui->getOptionsMenu();
	om->show();
	om->activateNetworkTab();

	return true;
}

bool StartServerMenu::handleArenaListboxSelectionChanged(const CEGUI::EventArgs& e){
    CEGUI::ListboxItem* i = this->arenaListbox->getFirstSelectedItem();
    if( i != NULL ){
        string description = this->gui->getSystem()->getGame()->getArenaFactory()->getArenaDescription( i->getText().c_str() );
        this->descriptionMultiLineEditbox->setText( description );
    }else{
        this->descriptionMultiLineEditbox->setText( CEGUI::String("[select an arena]") );
    }

    return true;
}
