#include "StringTokenizer.h"

//#include <iostream>

StringTokenizer::StringTokenizer(const string& delimiters, const string& quotes, bool keepQuotes){
	this->delimiters = delimiters;
	this->quotes = quotes;
	this->keepQuotes = keepQuotes;

//	this->lastInputString.clear();
	this->lastTokens.clear();
}

StringTokenizer::~StringTokenizer(){
}

const StringTokenizer::tokens_t& StringTokenizer::tokenize(const string& inputString){
	string::size_type startPos = 0;
	string::size_type endPos = 0;

	lastTokens.clear();
//	if( inputString.length() == 0 ){
//		return;
//	}

	while( startPos != string::npos ){

	// Skip delimiters
	startPos = inputString.find_first_not_of(delimiters, endPos);
	if( startPos == string::npos ){
		break;
	}
	if( quotes.find( inputString[startPos] ) != string::npos ){	// this is a quote
		endPos = inputString.find_first_of( quotes, startPos+1 );	// find closing quote
		if( endPos == string::npos ){	// no closing quote
			endPos = inputString.length();
			if( keepQuotes ){
				lastTokens.push_back( inputString.substr(startPos, endPos-startPos) );
			}else{
				lastTokens.push_back( inputString.substr(startPos+1, endPos-startPos) );
			}
		}else{	// closing quote
			if( keepQuotes ){
				lastTokens.push_back( inputString.substr(startPos, endPos-startPos+1) );
			}else{
				lastTokens.push_back( inputString.substr(startPos+1, endPos-startPos-1) );
			}
		}
	}else{	// no quote
		endPos = inputString.find_first_of( delimiters, startPos );	// find end of token
		if( endPos == string::npos ){
			endPos = inputString.length();
		}
		lastTokens.push_back( inputString.substr(startPos, endPos-startPos) );
	}

	endPos++;
//	cout << "[" << lastTokens.back() << "]" << endl;
	}

	return this->lastTokens;
}

const StringTokenizer::tokens_t& StringTokenizer::getLastTokens() const {
	return this->lastTokens;
}

