#ifndef __StringTokenizer_h__
#define __StringTokenizer_h__

#include <string>
#include <vector>

using namespace std;

class StringTokenizer{
public:
	typedef vector<string> tokens_t;

	StringTokenizer(const string& delimiters = " \t\n\r", const string& quotes = "\"", bool keepQuotes = false);
	~StringTokenizer();

	const tokens_t& tokenize(const string& inputString);
	const tokens_t& getLastTokens() const;

protected:
	string delimiters;
	string quotes;
	bool keepQuotes;
	string lastInputString;
	tokens_t lastTokens;
};


#endif // __StringTokenizer_h__
