#ifndef __System_h__
#define __System_h__

#include "main.h"

#include "FColor.h"
#include "Timer.h"
#include "Random.h"
#include "SystemCCmds.h"

class Logging;
class Console;
class Input;
class Graphics;
class Gui;
class Network;
class Sound;
class Game;

class System{
public:
	enum platforms_e{
		PLATFORM_WIN32,
		PLATFORM_LINUX,

		NUM_PLATFORMS
	};

	void initialize();
	void shutdown();

	bool isInitialized() const;

	// interface for logging (allows formatStrings and static access)
	static void log(const char* formatString, ...);
	static void log(const FColor& color, const char* formatString, ...);
	static void warn(const char* formatString, ...);
	static void error(const char* formatString, ...);

	void parseCommandLineArguments( const string& arguments );

	void mainLoop();

	void startGame();
	void endGame();

	void quit();

	Timer* getTimer() const;
	Random* getRandom() const;

	Logging* getLogging() const;
	Console* getConsole() const;
	Console& getConsoleRef();
	Graphics* getGraphics() const;
	Gui* getGui() const;
	Input* getInput() const;
	Game* getGame() const;
	Sound* getSound() const;
	Network* getNetwork() const;

	platforms_e getPlatform() const;
	void setPlatformString(const string& newPlatformString);
	const string& getPlatformString() const;
	void setVersionString(const string& newVersionString);
	const string& getVersionString() const;
	void setConfigDir(const string& newConfigDir);
	const string& getConfigDir() const;
	void setDataDir(const string& newDataDir);
	const string& getDataDir() const;
	void setLogDir(const string& newLogDir);
	const string& getLogDir() const;

	
	void setShouldStartGame(bool newShouldStartGame);
	bool getShouldStartGame() const;
	void setShouldQuit(bool newShouldQuit);
	bool getShouldQuit() const;

	static string debugStrings[10];

protected:
	vector<string> commandLineConsoleStrings;

	System();
	~System();

	void registerCCmds();
	void unregisterCCmds();
	void registerCVars();
	void unregisterCVars();

	void checkDirectories();
	void readSystemConfig();
	void writeSystemConfig();
	void readAutoExecConfig();

	void createGame();
	void destroyGame();

	bool initialized;

	Timer* timer;
	Random* random;

	Logging* logging;
	Console* console;
	Input* input;
	Graphics* graphics;
	Gui* gui;
	Network* network;
	Sound* sound;
	Game* game;

	platforms_e platform;
	string platformString;
	string versionString;
	string dataDir;
	string configDir;
	string logDir;


	bool shouldQuit;
	bool shouldStartGame;


	struct cVars_s{
	};
	cVars_s cVars;
	struct cCmds_s{
		CCmdSystemQuit* system_quit;
		CCmdSystemDebugCCmd1* system_debugccmd1;
	};
	cCmds_s cCmds;



	// Singleton interface
public:
	static System& getInstanceRef();
	static System* getInstance();
	static void createInstance();
	static void deleteInstance();
protected:
	static System* instance;

};

#endif // __System_h__
