#ifndef __TeleportationArea_h__
#define __TeleportationArea_h__

#include "Area.h"

class Vehicle;

class TeleportationArea: public Area {
public:
	static const unsigned long TELEPORTATION_INTERVAL;

	TeleportationArea();
	virtual ~TeleportationArea();

	virtual Area* clone() const;

	virtual void fromXmlElement( TiXmlElement* xmlElement );
	virtual TiXmlElement toXmlElement() const;
	virtual void calculateChecksum();

	virtual void attach( Game* game );
	virtual void detach();

	virtual bool canAffectVehicle( Vehicle* vehicle ) const;
	virtual void affectVehicle( Vehicle* vehicle );


protected:
	unsigned int teamFlags;
	FVector3 targetLocation;

	unsigned long lastTeleportationMillis;

	Ogre::SceneNode* sceneNode;

	void parseTargetLocation(TiXmlElement* targetLocationElement);
};

#endif // __TeleportationArea_h__
