#ifndef __VehicleFactory_h__
#define __VehicleFactory_h__

#include <map>
#include <vector>
#include <string>
using namespace std;

class Vehicle;
class Game;

class VehicleFactory{
public:
	VehicleFactory( Game* game );
	~VehicleFactory();

	void addVehicle( const string& vehicleFilePath );
	void removeVehicle( const string& name );

	Vehicle* createVehicle( const string& name ) const;
	void destroyVehicle( Vehicle* vehicle ) const;

	bool isVehicleAvailable( const string& name ) const;
	vector<string> getVehicleNames() const;
	const string& getVehicleDescription( const string& name ) const;
	int getVehicleNumWeaponSlots( const string& name ) const;

protected:
	Game* game;

	typedef map<string, Vehicle*> vehiclesByName_t;
	vehiclesByName_t vehiclesByName;

};

#endif // __VehicleFactory_h__
