#ifndef __Weapon_h__
#define __Weapon_h__

#include <tinyxml.h>

#include <string>
using namespace std;

#include "FVectors.h"

class Shot;
class Vehicle;
class Effect;

class Weapon{
public:

	struct info_s{
		string description;
	};

	struct graphicalProperties_s{
		string mesh;
		string hudIcon;
		string muzzleEffect;
		string overheatedEffect;
	};

	struct physicalProperties_s{
		float mass;
		int ammoCapacity;
		int heatCapacity;
		float heatOutput;
		float reloadTime;
		float recoilImpulse;

		FVector3 muzzlePoint;
	};

	struct acousticalProperties_s{
	};

	Weapon();
	virtual ~Weapon();

	virtual Weapon* clone() const;
	virtual void reset();

//	virtual void loadFromFile( const string& weaponFilePath );
	virtual void fromXmlElement( TiXmlElement* xmlElement );
	virtual TiXmlElement toXmlElement() const;

	virtual void attach(Vehicle* vehicle, int slot);
	virtual void detach();
	virtual void update( float deltaT );

	virtual bool isReady() const;
	virtual void fire();
	virtual void setUpShot( Shot* s );

	virtual void restockAmmoRel( float relAmount );
	virtual void overheat();

	const string& getName() const;
	const string& getShot() const;
	virtual const string& getDescription() const;
	virtual void calculateChecksum();
	virtual unsigned int getChecksum() const;
//	weaponTypes_e getWeaponType() const;
	const graphicalProperties_s& getGraphicalProperties() const;
	const physicalProperties_s& getPhysicalProperties() const;

	float getHeat() const;
	int getAmmo() const;
	bool isOverheated() const;

protected:
	Vehicle* vehicle;
	int slot;

	string name;
	string shot;
	unsigned int checksum;

	info_s info;
	graphicalProperties_s graphicalProperties;
	physicalProperties_s physicalProperties;
	acousticalProperties_s acousticalProperties;

	int ammo;
	float heat;
	float secondsUntilReloaded;
	bool overheated;

	Ogre::SceneNode* sceneNode;
	Ogre::Entity* entity;
	Ogre::AnimationState* animationState;
	Effect* overheatedEffect;

	virtual void parseInfo(TiXmlElement* infoElement);
	virtual void parseDescription(TiXmlElement* descriptionElement);
	virtual void parseGraphicalProperties( TiXmlElement* graphicalPropertiesElement );
	virtual void parsePhysicalProperties( TiXmlElement* physicalPropertiesElement );
	virtual void parseAcousticalProperties( TiXmlElement* acousticalPropertiesElement );

//	virtual void parseShotProperties( TiXmlElement* shotPropertiesElement );
};

#endif // __Weapon_h__
