#include "XmlUtils.h"

#include "XmlUtils.h"

Ogre::Vector3 XmlUtils::readOgreVector3(TiXmlElement* elt){
	Ogre::Vector3 ret = Ogre::Vector3::ZERO;

	const char* tmp = elt->Attribute("x");
	if( tmp != NULL ){
		ret[0] = atof(tmp);
	}
	
	tmp = elt->Attribute("y");
	if( tmp != NULL ){
		ret[1] = atof(tmp);
	}

	tmp = elt->Attribute("z");
	if( tmp != NULL ){
		ret[2] = atof(tmp);
	}

	return ret;
}

Ogre::Quaternion XmlUtils::readOgreQuaternion(TiXmlElement* elt){
	Ogre::Quaternion ret = Ogre::Quaternion::IDENTITY;

	const char* tmp = elt->Attribute("qx");
	if( tmp != NULL ){
		ret.x = atof(tmp);
	}
	
	tmp = elt->Attribute("qy");
	if( tmp != NULL ){
		ret.y = atof(tmp);
	}

	tmp = elt->Attribute("qz");
	if( tmp != NULL ){
		ret.z = atof(tmp);
	}
	
	tmp = elt->Attribute("qw");
	if( tmp != NULL ){
		ret.w = atof(tmp);
	}

	return ret;
}

Ogre::ColourValue XmlUtils::readOgreColourValue(TiXmlElement* elt){
	Ogre::ColourValue ret = Ogre::ColourValue::Black;

	const char* tmp = elt->Attribute("r");
	if( tmp != NULL ){
		ret.r = atof(tmp);
	}
	
	tmp = elt->Attribute("g");
	if( tmp != NULL ){
		ret.g = atof(tmp);
	}

	tmp = elt->Attribute("b");
	if( tmp != NULL ){
		ret.b = atof(tmp);
	}

	tmp = elt->Attribute("a");
	if( tmp != NULL ){
		ret.a = atof(tmp);
	}

	return ret;
}

Ogre::Plane XmlUtils::readOgrePlane(TiXmlElement* elt){
	Ogre::Plane ret( Ogre::Vector3(0.0, 1.0, 0.0), 0.0);

	const char* tmp = elt->Attribute("planeX");
	if( tmp != NULL ){
		ret.normal.x = atof(tmp);
	}

	tmp = elt->Attribute("planeY");
	if( tmp != NULL ){
		ret.normal.y = atof(tmp);
	}
	
	tmp = elt->Attribute("planeZ");
	if( tmp != NULL ){
		ret.normal.z = atof(tmp);
	}

	tmp = elt->Attribute("planeD");
	if( tmp != NULL ){
		ret.d = atof(tmp);
	}
	
	return ret;
}




FVector3 XmlUtils::readFVector3(TiXmlElement* elt){
	FVector3 ret = FVector3::ZERO;

	const char* tmp = elt->Attribute("x");
	if( tmp != NULL ){
		ret[0] = atof(tmp);
	}
	
	tmp = elt->Attribute("y");
	if( tmp != NULL ){
		ret[1] = atof(tmp);
	}

	tmp = elt->Attribute("z");
	if( tmp != NULL ){
		ret[2] = atof(tmp);
	}

	return ret;
}

FQuaternion XmlUtils::readFQuaternion(TiXmlElement* elt){
	FQuaternion ret = FQuaternion::IDENTITY;

	const char* tmp = elt->Attribute("qx");
	if( tmp != NULL ){
		ret.x = atof(tmp);
	}
	
	tmp = elt->Attribute("qy");
	if( tmp != NULL ){
		ret.y = atof(tmp);
	}

	tmp = elt->Attribute("qz");
	if( tmp != NULL ){
		ret.z = atof(tmp);
	}
	
	tmp = elt->Attribute("qw");
	if( tmp != NULL ){
		ret.s = atof(tmp);
	}

	return ret;
}

FColor XmlUtils::readFColor(TiXmlElement* elt){
	FColor ret = FColor::BLACK;

	const char* tmp = elt->Attribute("r");
	if( tmp != NULL ){
		ret.r = atof(tmp);
	}
	
	tmp = elt->Attribute("g");
	if( tmp != NULL ){
		ret.g = atof(tmp);
	}

	tmp = elt->Attribute("b");
	if( tmp != NULL ){
		ret.b = atof(tmp);
	}

	tmp = elt->Attribute("a");
	if( tmp != NULL ){
		ret.a = atof(tmp);
	}

	return ret;
}


bool XmlUtils::readBoolProperty(TiXmlElement* elt, const string& name, bool& ret){
	for( TiXmlElement* propElt = elt->FirstChildElement(); propElt != NULL; propElt = propElt->NextSiblingElement() ){
		if( string( propElt->Value() ) == string("property")
				&& propElt->Attribute("name") != NULL && string( propElt->Attribute("name") ) == name
				&& propElt->Attribute("value") != NULL ){
//			printf("JO: %s\n", name.c_str());
			ret = string( propElt->Attribute("value") ) == string( "true" ) ? true : false;
			return true;
		}
	}
	return false;
}
bool XmlUtils::readIntProperty(TiXmlElement* elt, const string& name, int& ret){
	for( TiXmlElement* propElt = elt->FirstChildElement(); propElt != NULL; propElt = propElt->NextSiblingElement() ){
		if( string( propElt->Value() ) == string("property")
				&& propElt->Attribute("name") != NULL && string( propElt->Attribute("name") ) == name
				&& propElt->Attribute("value") != NULL ){
//			printf("JO: %s\n", name.c_str());
			ret = atoi( propElt->Attribute("value") );
			return true;
		}
	}
	return false;
}
bool XmlUtils::readFloatProperty(TiXmlElement* elt, const string& name, float& ret){
	for( TiXmlElement* propElt = elt->FirstChildElement(); propElt != NULL; propElt = propElt->NextSiblingElement() ){
		if( string( propElt->Value() ) == string("property")
				&& propElt->Attribute("name") != NULL && string( propElt->Attribute("name") ) == name
				&& propElt->Attribute("value") != NULL ){
//			printf("JO: %s\n", name.c_str());
			ret = atof( propElt->Attribute("value") );
			return true;
		}
	}
	return false;
}
bool XmlUtils::readStringProperty(TiXmlElement* elt, const string& name, string& ret){
	for( TiXmlElement* propElt = elt->FirstChildElement(); propElt != NULL; propElt = propElt->NextSiblingElement() ){
		if( string( propElt->Value() ) == string("property")
				&& propElt->Attribute("name") != NULL && string( propElt->Attribute("name") ) == name
				&& propElt->Attribute("value") != NULL ){
//			printf("JO: %s\n", name.c_str());
			ret = string( propElt->Attribute("value") );
			return true;
		}
	}
	return false;
}
bool XmlUtils::readFVector3Property(TiXmlElement* elt, const string& name, FVector3& ret){
	for( TiXmlElement* propElt = elt->FirstChildElement(); propElt != NULL; propElt = propElt->NextSiblingElement() ){
		if( string( propElt->Value() ) == string("property")
				&& propElt->Attribute("name") != NULL && string( propElt->Attribute("name") ) == name
				&& propElt->Attribute("value") != NULL ){
//			printf("JO: %s\n", name.c_str());
			const char* val = propElt->Attribute("value");
			int n = sscanf( val, "x:%f y:%f z:%f", &ret.x, &ret.y, &ret.z );
			if( n == 3 ){
				return true;
			}else{
				return false;
			}
		}
	}
	return false;
}
bool XmlUtils::readFColorProperty(TiXmlElement* elt, const string& name, FColor& ret){
	for( TiXmlElement* propElt = elt->FirstChildElement(); propElt != NULL; propElt = propElt->NextSiblingElement() ){
		if( string( propElt->Value() ) == string("property")
				&& propElt->Attribute("name") != NULL && string( propElt->Attribute("name") ) == name
				&& propElt->Attribute("value") != NULL ){
//			printf("JO: %s\n", name.c_str());
			const char* val = propElt->Attribute("value");
			int n = sscanf( val, "r:%f g:%f b:%f", &ret.r, &ret.g, &ret.b );
			if( n == 3 ){
				return true;
			}else{
				return false;
			}
		}
	}
	return false;
}
