#ifndef __XmlUtils_h__
#define __XmlUtils_h__

#include "FVectors.h"
#include "FQuaternion.h"
#include "FColor.h"

#include <Ogre.h>
#include <tinyxml.h>

#include <string>
using namespace std;

class XmlUtils{
public:

	static Ogre::Vector3 readOgreVector3(TiXmlElement* elt);
	static Ogre::Quaternion readOgreQuaternion(TiXmlElement* elt);
	static Ogre::ColourValue readOgreColourValue(TiXmlElement* elt);
	static Ogre::Plane readOgrePlane(TiXmlElement* elt);

	static FColor readFColor(TiXmlElement* elt);
	static FVector3 readFVector3(TiXmlElement* elt);
	static FQuaternion readFQuaternion(TiXmlElement* elt);

	static bool readBoolProperty(TiXmlElement* elt, const string& name, bool& ret);
	static bool readIntProperty(TiXmlElement* elt, const string& name, int& ret);
	static bool readFloatProperty(TiXmlElement* elt, const string& name, float& ret);
	static bool readStringProperty(TiXmlElement* elt, const string& name, string& ret);
	static bool readFVector3Property(TiXmlElement* elt, const string& name, FVector3& ret);
	static bool readFColorProperty(TiXmlElement* elt, const string& name, FColor& ret);
};


#endif // __XmlUtils_h__
