#ifndef __ArenaFactory_h__
#define __ArenaFactory_h__

#include <map>
#include <vector>
#include <string>
using namespace std;

class Arena;
class Game;

class ArenaFactory{
public:
	ArenaFactory(Game* game);
	~ArenaFactory();

	void addArena(const string& arenaFilePath);
	void removeArena(const string& name);

	Arena* createArena(const string& name) const;
	void destroyArena(Arena* arena) const;

	vector<string> getArenaNames() const;
	const string& getArenaDescription( const string& arenaName ) const;

protected:
	Game* game;

	typedef map<string, Arena*> arenasByName_t;
	arenasByName_t arenasByName;

};

#endif // __ArenaFactory_h__
